% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictions.R
\name{predictions}
\alias{predictions}
\title{Adjusted Predictions}
\usage{
predictions(model, variables = NULL, newdata = NULL, conf.level = 0.95, ...)
}
\arguments{
\item{model}{Model object}

\item{variables}{Character vector. Compute Adjusted Predictions for
combinations of each of these variables. Factor levels are considered at
each of their levels. Numeric variables variables are considered at Tukey's
Five-Number Summaries. \code{NULL} uses the original data used to fit the model.}

\item{newdata}{A dataset over which to compute adjusted predictions. \code{NULL} uses
the original data used to fit the model.}

\item{conf.level}{The confidence level to use for the confidence interval.
No interval is computed if \code{conf.int=NULL}.  Must be strictly greater than 0
and less than 1. Defaults to 0.95, which corresponds to a 95 percent
confidence interval.}

\item{...}{Additional arguments are pushed forward to \code{predict()}.}
}
\value{
A \code{data.frame} with a \code{predicted} column with predictions.
}
\description{
Compute model-adjusted predictions (fitted values) for a "grid" of regressor values.
}
