% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_predict.R, R/methods_MASS.R,
%   R/methods_aod.R, R/methods_nnet.R, R/methods_brglm2.R, R/methods_brms.R,
%   R/methods_crch.R, R/methods_lme4.R, R/methods_ordinal.R,
%   R/methods_quantreg.R, R/methods_rstanarm.R, R/methods_survival.R
\name{get_predict}
\alias{get_predict}
\alias{get_predict.default}
\alias{get_predict.polr}
\alias{get_predict.glmmPQL}
\alias{get_predict.glimML}
\alias{get_predict.multinom}
\alias{get_predict.brmultinom}
\alias{get_predict.brmsfit}
\alias{get_predict.crch}
\alias{get_predict.merMod}
\alias{get_predict.clm}
\alias{get_predict.rq}
\alias{get_predict.stanreg}
\alias{get_predict.coxph}
\title{Get predicted values from a model object (internal function)}
\usage{
get_predict(model, newdata, type, ...)

\method{get_predict}{default}(
  model,
  newdata = insight::get_data(model),
  type = "response",
  conf.level = NULL,
  ...
)

\method{get_predict}{polr}(
  model,
  newdata = insight::get_data(model),
  type = "probs",
  conf.level = NULL,
  ...
)

\method{get_predict}{glmmPQL}(
  model,
  newdata = insight::get_data(model),
  type = "response",
  conf.level = NULL,
  ...
)

\method{get_predict}{glimML}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{multinom}(model, newdata = insight::get_data(model), type = "probs", ...)

\method{get_predict}{brmultinom}(model, newdata = insight::get_data(model), type = "probs", ...)

\method{get_predict}{brmsfit}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{crch}(model, newdata = NULL, type = "location", ...)

\method{get_predict}{merMod}(
  model,
  newdata = insight::get_data(model),
  type = "response",
  conf.level = NULL,
  ...
)

\method{get_predict}{clm}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{rq}(
  model,
  newdata = insight::get_data(model),
  type = NULL,
  conf.level = NULL,
  ...
)

\method{get_predict}{stanreg}(model, newdata = insight::get_data(model), type = "response", ...)

\method{get_predict}{coxph}(
  model,
  newdata = insight::get_data(model),
  type = "lp",
  conf.level = NULL,
  ...
)
}
\arguments{
\item{model}{Model object}

\item{newdata}{A dataset over which to compute marginal effects. \code{NULL} uses
the original data used to fit the model.}

\item{type}{Type(s) of prediction as string or vector This can
differ based on the model type, but will typically be a string such as:
"response", "link", "probs", or "zero".}

\item{...}{Additional arguments are pushed forward to \code{predict()}.}
}
\value{
A vector of predicted values of length equal to the number of rows
in \code{newdata}. For models with multi-level outcomes (e.g., multinomial
logit), this function returns a matrix of predicted values with column names
equal to each of the levels/groups.
}
\description{
Get predicted values from a model object (internal function)
}
\keyword{internal}
