% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVBiomass.R
\name{CVBiomass}
\alias{CVBiomass}
\title{Calculates the Coefficient of Variation of the Biomass}
\usage{
CVBiomass(X, wind = 5, negative = FALSE, years)
}
\arguments{
\item{X}{A dataframe of fishery independent data derived from research vessel
survey data or model output, with columns \code{YEAR}, \code{ID}, and
\code{BIOMASS}.  \code{YEAR} indicates the year the observation was
recorded, \code{ID} is an area code indicating where the observation was
recorded, and \code{BIOMASS} is the total recorded biomass (stratified and
corrected for catchability as required). (Note: if \code{X} has an
additional \code{SPECIES} column, the function will automatically calculate
the total biomass).}

\item{wind}{Window for the moving average. The first and last
\code{floor(wind/2)} values of the indicator are assigned \code{NA} to
account for the moving average. Default is \code{wind = 5} years.}

\item{negative}{If \code{negative = TRUE}, the indicator will be multiplied by
-1 so that the expected response is to decrease with increasing fishing
pressure. Default is \code{negative = FALSE}.}

\item{years}{A vector of years for which to calculate indicator.}
}
\value{
Returns a dataframe with three columns: \code{ID}, \code{YEAR}, and
 \code{CVBiomass}.

 The first and last \code{floor(wind/2)} values of the indicator are assigned
 \code{NA} to account for the moving average. If there is no data for spatial
 scale \eqn{j} in year \eqn{i}, indicator value is assigned NA.
}
\description{
This function calculates the Coefficient of Variation of the
 Biomass for \eqn{j} areas and \eqn{i} years.
}
\details{
The Coefficient of Variation of the Biomass (CVBiomass) was estimated
 as an n-year moving average (Blanchard and Boucher, 2001):

 CVBiomass = sd(total biomass for the past n years)/mean(total biomass for
 the past n years)
}
\examples{
data(X)
CVBiomass(X, wind = 5, negative = TRUE, years = c(2014:2019))
}
\references{
Bundy A, Gomez C, Cook AM. 2017. Guidance framework for the
 selection and evaluation of ecological indicators. Can. Tech. Rep. Fish.
 Aquat. Sci. 3232: xii + 212 p.

 Blanchard F, Boucher J (2001) Temporal variability of total biomass in
 harvested communities of demersal fishes. Fisheries Research. 49. 283–293.
 10.1016/S0165-7836(00)00203-4.

 Shin, YJ, Shannon LJ, Bundy A, Coll M, Aydin K, Bez N, Blanchard JL, Borges,
 MF, Diallo I, Diaz E, Heymans JJ, Hill L, Johannesen E, Jouffre D, Kifani S,
 Labrosse P, Link JS, Mackinson S, Masski H, Möllmann C, Neira S, Ojaveer H,
 Ould Mohammed Abdallahi ., Perry I, Thiao D, Yemane D, and Cury PM. 2010.
 Using indicators for evaluating, comparing and communicating the ecological
 status of exploited marine ecosystems. Part 2: Setting the scene. ICES
 Journal of Marine Science, 67: 692-716
}
\seealso{
Other stability and resistance indicators: \code{\link{IVILandings}},
  \code{\link{allStability}}, \code{\link{biomassPerTL}},
  \code{\link{meanMaxAge}}, \code{\link{meanMaxLength}}
}
\author{
Danielle Dempsey \email{Danielle.Dempsey@dfo-mpo.gc.ca}, Adam Cook,
 Catalina Gomez, Alida Bundy
}
\concept{stability and resistance indicators}
