% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_model.R
\name{market_descriptives}
\alias{market_descriptives}
\alias{demand_descriptives}
\alias{supply_descriptives}
\alias{demand_descriptives,market_model-method}
\alias{supply_descriptives,market_model-method}
\title{Market force data descriptive statistics}
\usage{
demand_descriptives(object)

supply_descriptives(object)

\S4method{demand_descriptives}{market_model}(object)

\S4method{supply_descriptives}{market_model}(object)
}
\arguments{
\item{object}{A model object.}
}
\value{
A data frame containing descriptive statistics.
}
\description{
Market force data descriptive statistics
}
\details{
Calculates and returns basic descriptive statistics for the model's demand
or supply side data. Factor variables are excluded from the calculations. The function
calculates and returns:
\itemize{
\item \code{nobs} Number of observations.
\item \code{nmval} Number of missing values.
\item \code{min} Minimum observation.
\item \code{max} Maximum observation.
\item \code{range} Observations' range.
\item \code{sum} Sum of observations.
\item \code{median} Median observation.
\item \code{mean} Mean observation.
\item \code{mean_se} Mean squared error.
\item \code{mean_ce} Confidence interval bound.
\item \code{var} Variance.
\item \code{sd} Standard deviation.
\item \code{coef_var} Coefficient of variation.
}
}
\section{Functions}{
\itemize{
\item \code{demand_descriptives}: Demand descriptive statistics.

\item \code{supply_descriptives}: Supply descriptive statistics.
}}

\examples{
# initialize the basic model using the houses dataset
model <- new(
  "diseq_basic", # model type
  subject = ID, time = TREND, quantity = HS, price = RM,
  demand = RM + TREND + W + CSHS + L1RM + L2RM + MONTH,
  supply = RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH,
  fair_houses(), # data
  correlated_shocks = FALSE # allow shocks to be correlated
)

# get descriptive statistics of demand side variables
demand_descriptives(model)

# get descriptive statistics of supply side variables
supply_descriptives(model)
}
