% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_functions4Fitting.R
\name{multinomialConfidenceIntervals}
\alias{multinomialConfidenceIntervals}
\title{A function to compute multinomial confidence intervals of DTMC}
\usage{
multinomialConfidenceIntervals(transitionMatrix, countsTransitionMatrix,
  confidencelevel = 0.95)
}
\arguments{
\item{transitionMatrix}{An estimated transition matrix.}

\item{countsTransitionMatrix}{Empirical (conts) transition matrix, on which the \code{transitionMatrix} was performed.}

\item{confidencelevel}{confidence interval level.}
}
\value{
Two matrices containing the confidence intervals.
}
\description{
Return estimated transition matrix assuming a Multinomial Distribution
}
\examples{
seq<-c("a", "b", "a", "a", "a", "a", "b", "a", "b", "a", "b", "a", "a", "b", "b", "b", "a")
mcfit<-markovchainFit(data=seq,byrow=TRUE)
seqmat<-createSequenceMatrix(seq)
multinomialConfidenceIntervals(mcfit$estimate@transitionMatrix, seqmat, 0.95)
}
\references{
Constructing two-sided simultaneous confidence intervals 
for multinomial proportions for small counts in a large number of cells. 
Journal of Statistical Software 5(6) (2000)
}
\seealso{
\code{markovchainFit}

\code{\link{markovchain}}
}
