% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classesAndMethods.R
\docType{methods}
\name{states}
\alias{states}
\alias{states,markovchain-method}
\title{Defined states of a transition matrix}
\usage{
states(object)

\S4method{states}{markovchain}(object)
}
\arguments{
\item{object}{A discrete \code{markovchain} object}
}
\value{
The character vector corresponding to states slot.
}
\description{
This method returns the states of a transition matrix.
}
\examples{
statesNames <- c("a", "b", "c")
markovB <- new("markovchain", states = statesNames, transitionMatrix =
                matrix(c(0.2, 0.5, 0.3, 0, 1, 0, 0.1, 0.8, 0.1), nrow = 3,
                byrow = TRUE, dimnames=list(statesNames,statesNames)),
                name = "A markovchain Object" 
)
states(markovB)
names(markovB)

}
\references{
A First Course in Probability (8th Edition), Sheldon Ross, Prentice Hall 2010
}
\seealso{
\code{\linkS4class{markovchain}}
}
\author{
Giorgio Spedicato
}
