% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask.R
\name{lotsOfMasks}
\alias{lotsOfMasks}
\title{Generate and apply multiple masks to a map}
\usage{
lotsOfMasks(expertRaster, maskStack, maskBounds)
}
\arguments{
\item{expertRaster}{The binary expert map (1s and 0s), rasterized with the same projection as `maskStack`}

\item{maskStack}{A stack of *named* layers from which masks will be made}

\item{maskBounds}{A data.frame with columns indicating the layer name (matching the names in maskStack), and the min and max values of that layer to be used for masking.}
}
\value{
a RasterStack
}
\description{
Based on a potential distribution, environmental rasters, and bounds for suitable habitat on the environmental rasters
}
\details{
See Examples.
}
\examples{
r1 <- raster::raster(nrows=108, ncols=21, xmn=0, xmx=10)
raster::values(r1)<- sort(runif(n = (108*21)))
r1[r1>0.5] <- 1
r1[r1<0.5] <- 0
r2 <- raster::raster(nrows=108, ncols=21, xmn=0, xmx=10)
raster::values(r2) <- runif(n=(108*21))
r3 <- raster::raster(nrows=108, ncols=21, xmn=0, xmx=10)
raster::values(r3) <- runif(n=(108*21))
maskStack <- raster::stack(r2, r3)
names(maskStack) <- c("r2", "r3")
minbounds <- c(0.3, 0.4)
maxbounds <- c(0.4, 0.5)
maskBounds <- data.frame(cbind(c("r2", "r3"), minbounds, maxbounds))
colnames(maskBounds)<- c("Layer", "Min Value", "Max Value")
maskBounds[,2] <- as.numeric(as.character(maskBounds[,2]))
maskBounds[,3] <- as.numeric(as.character(maskBounds[,3]))
out <- lotsOfMasks(expertRaster = r1, maskStack = maskStack, maskBounds = maskBounds)


}
\author{
Cory Merow <cory.merow@gmail.com>,
}
