% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radii.R
\name{add_radii_of_gyration}
\alias{add_radii_of_gyration}
\title{Add radii of gyration}
\usage{
add_radii_of_gyration(df)
}
\arguments{
\item{df}{A data frame with (at least) these columns: \code{id}, \code{mass}, \code{Cx},
\code{Cy}, \code{Cz}, \code{Ixx}, \code{Iyy}, \code{Izz}, \code{Ixy}, \code{Ixz}, \code{Iyz}, \code{POIconv}, \code{Ipoint}.}
}
\value{
A data frame with the same columns as \code{df}, plus
radii of gyration in columns \code{kx}, \code{ky}, and \code{kz}.`
}
\description{
\code{add_radii_of_gyration()} adds calculated radii of gyration to a data frame
of rolled-up mass properties.

Radii of gyration are calculated directly from moments of inertia and mass;
they are not recursively-defined, and do not require a rollup method.
}
\examples{
test_table_rollup <- rollup_mass_props(test_tree, test_table)
add_radii_of_gyration(test_table_rollup)

}
