% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{shade}
\alias{shade}
\alias{shade.figure}
\title{Shade rule (Method)}
\usage{
shade(fig, n, rule, ...)

\method{shade}{figure}(fig, n = 1, rule = "shade", ...)
}
\arguments{
\item{fig}{The figure on which the rule is applied}

\item{n}{integer, defines the color of the shading. Default is 1 (white). Other options are 2 (grey) and 3 (black)}

\item{rule}{character, defines the rule for shading the figure}

\item{...}{Other arguments}
}
\value{
An object of class figure with different shading characteristics

An object of class figure with different shading characteristics
}
\description{
Apply a change in the shading of the figure
}
\section{Methods (by class)}{
\itemize{
\item \code{shade(figure)}: Change the shade of a figure

Apply a change in the shading of the figure

}}
\examples{
# draw default triangle
draw(triangle())

# make it grey
draw(shade(triangle(), 2))
# draw default triangle
draw(triangle())

# make it grey
draw(shade(triangle(), 2))
}
