/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.common.util.tools;

import choco.IPretty;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.common.util.iterators.EmptyIterator;
import choco.kernel.common.util.tools.TaskUtils;
import choco.kernel.model.constraints.automaton.FA.FiniteAutomaton;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.solver.search.limit.Limit;
import choco.kernel.solver.search.measure.ISearchMeasures;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.ITask;
import java.util.Collection;
import java.util.Iterator;

public class StringUtils {
    private static long next;

    private StringUtils() {
    }

    public static String pad(String str, int padlen, String pad) {
        StringBuilder padding = new StringBuilder(32);
        int len = Math.abs(padlen) - str.length();
        if (len < 1) {
            return str;
        }
        for (int i = 0; i < len; ++i) {
            padding.append(pad);
        }
        return padlen < 0 ? padding.append(str).toString() : padding.insert(0, str).toString();
    }

    public static DisposableIterator<String> getOptionIterator(final String options) {
        if (options != null && options.length() > 0) {
            return new DisposableIterator<String>(){
                int b;
                int e = -1;

                @Override
                public boolean hasNext() {
                    this.b = this.e + 1;
                    while ((this.e = options.indexOf(32, this.b)) >= 0) {
                        if (this.e > this.b) {
                            return true;
                        }
                        this.b = this.e + 1;
                    }
                    this.e = options.length();
                    return this.e > this.b;
                }

                @Override
                public String next() {
                    return options.substring(this.b, this.e);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Immutable");
                }

                @Override
                public void dispose() {
                }
            };
        }
        return EmptyIterator.get();
    }

    public static String pretty(IPretty[] elems, int begin, int end) {
        StringBuilder buffer = new StringBuilder(32);
        buffer.append("{ ");
        for (int i = begin; i < end; ++i) {
            buffer.append(elems[i].pretty()).append(", ");
        }
        buffer.deleteCharAt(buffer.length() - 2);
        buffer.append('}');
        return new String(buffer);
    }

    public static String pretty(IPretty ... elems) {
        return StringUtils.pretty(elems, 0, elems.length);
    }

    public static String prettyOnePerLine(Collection<? extends IPretty> elems) {
        return StringUtils.prettyOnePerLine(elems.iterator());
    }

    public static String prettyOnePerLine(Iterator<? extends IPretty> iter) {
        StringBuilder buffer = new StringBuilder(32);
        while (iter.hasNext()) {
            buffer.append(iter.next().pretty()).append('\n');
        }
        return new String(buffer);
    }

    public static String pretty(Collection<? extends IPretty> elems) {
        return StringUtils.pretty(elems.iterator());
    }

    public static String pretty(Iterator<? extends IPretty> iter) {
        StringBuilder buffer = new StringBuilder(32);
        buffer.append("{ ");
        if (iter.hasNext()) {
            while (iter.hasNext()) {
                buffer.append(iter.next().pretty()).append(", ");
            }
            buffer.deleteCharAt(buffer.length() - 2);
        }
        buffer.append('}');
        return new String(buffer);
    }

    public static String pretty(int[] lval) {
        StringBuilder sb = new StringBuilder(32);
        sb.append('{');
        for (int i = 0; i < lval.length - 1; ++i) {
            sb.append(lval[i]);
            sb.append(',');
        }
        sb.append(lval[lval.length - 1]);
        sb.append('}');
        return sb.toString();
    }

    public static String pretty(int[][] lvals) {
        StringBuilder sb = new StringBuilder(32);
        sb.append('{');
        for (int i = 0; i < lvals.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            int[] lval = lvals[i];
            sb.append('{');
            for (int j = 0; j < lval.length; ++j) {
                if (j > 0) {
                    sb.append(',');
                }
                int val = lval[j];
                sb.append(val);
            }
            sb.append('}');
        }
        sb.append('}');
        return sb.toString();
    }

    public static String pretty(int c) {
        if (c > 0) {
            return " + " + c;
        }
        if (c < 0) {
            return " - " + Math.abs(c);
        }
        return "";
    }

    public static String prettyOnePerLine(ISearchMeasures measures) {
        StringBuilder b = new StringBuilder(32);
        for (Limit type : Limit.values()) {
            int val = type.getValue(measures);
            if (val == Integer.MIN_VALUE) continue;
            b.append("\n  ").append(type.getUnit()).append(": ").append(val);
        }
        if (b.length() > 0) {
            b.deleteCharAt(0);
        }
        return new String(b);
    }

    public static String pretty(ISearchMeasures measures) {
        StringBuilder b = new StringBuilder(32);
        for (Limit type : Limit.values()) {
            int val = type.getValue(measures);
            if (val == Integer.MIN_VALUE) continue;
            b.append(", ").append(val).append(' ').append(type.getUnit());
        }
        if (b.length() > 1) {
            b.delete(0, 2);
        }
        return new String(b);
    }

    public static String toCharExp(String strRegExp) {
        StringBuilder b = new StringBuilder(32);
        for (int i = 0; i < strRegExp.length(); ++i) {
            int out;
            char c = strRegExp.charAt(i);
            if (c == '<') {
                out = strRegExp.indexOf(62, i + 1);
                int tmp = Integer.parseInt(strRegExp.substring(i + 1, out));
                b.append(FiniteAutomaton.getCharFromInt(tmp));
                i = out;
                continue;
            }
            if (Character.isDigit(c)) {
                b.append(FiniteAutomaton.getCharFromInt(Character.getNumericValue(c)));
                continue;
            }
            if (c == '{') {
                out = strRegExp.indexOf(125, i + 1);
                b.append(c);
                for (int d = i + 1; d <= out; ++d) {
                    b.append(strRegExp.charAt(d));
                }
                i = out;
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static String toIntExp(String charExp) {
        StringBuilder b = new StringBuilder(32);
        for (int i = 0; i < charExp.length(); ++i) {
            int c = charExp.charAt(i);
            if (c == 40 || c == 41 || c == 42 || c == 43 || c == 124) {
                b.append((char)c);
                continue;
            }
            int n = c;
            if (n >= 35) {
                --n;
            }
            if (n < 10) {
                b.append(n);
                continue;
            }
            b.append('<').append(n).append('>');
        }
        return b.toString();
    }

    public static String randomName() {
        return "TMP_" + next++;
    }

    public static String format(int lb, int ub) {
        return lb == ub ? String.valueOf(lb) : lb + ".." + ub;
    }

    public static String format(IntegerVariable iv) {
        return StringUtils.format(iv.getLowB(), iv.getUppB());
    }

    public static String format(IntDomainVar iv) {
        return StringUtils.format(iv.getInf(), iv.getSup());
    }

    public static String pretty(ITask t) {
        StringBuilder b = new StringBuilder(32);
        b.append(t.getName()).append(":[");
        b.append(StringUtils.format(t.getEST(), t.getLST())).append(" + ");
        b.append(StringUtils.format(t.getMinDuration(), t.getMaxDuration())).append(" -> ");
        b.append(StringUtils.format(t.getECT(), t.getLCT())).append(']');
        return new String(b);
    }

    public static String toDotty(ITask t, String label, boolean format, String ... options) {
        StringBuilder b = new StringBuilder(32);
        b.append(t.getID()).append("[ shape=record,");
        b.append("label=\"{ ");
        b.append('{').append(t.getEST()).append('|');
        b.append(StringUtils.format(t.getMinDuration(), t.getMaxDuration()));
        b.append('|').append(t.getECT()).append('}');
        b.append('|').append(t.getName());
        if (!t.isScheduled()) {
            b.append('|');
            b.append('{').append(t.getLST()).append('|').append(TaskUtils.getSlack(t)).append('|').append(t.getLCT()).append('}');
        }
        b.append(" }");
        if (label != null) {
            b.append(label);
        }
        b.append(" \"");
        if (format) {
            if (t.isScheduled()) {
                b.append(", style=bold");
            } else {
                b.append(", style=\"dashed,bold\"");
            }
        }
        if (options != null) {
            for (int i = 0; i < options.length; ++i) {
                b.append(", ").append(options[i]);
            }
        }
        b.append(" ];");
        return new String(b);
    }

    public static String dirName(String n1, String n2) {
        return "dir" + (n1 != null && n2 != null && !n1.isEmpty() && !n2.isEmpty() ? "-" + n1 + "-" + n2 : "");
    }

    public static String dirRandomName(String n1, String n2) {
        return StringUtils.randomName() + "-" + StringUtils.dirName(n1, n2);
    }
}

