/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.demo;

import java.io.IOException;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.Pseudograph;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.jgrapht.traverse.CrossComponentIterator;
import org.jgrapht.traverse.DepthFirstIterator;

public final class PerformanceDemo {
    public static void main(String[] stringArray) {
        Object object;
        long l = System.currentTimeMillis();
        PerformanceDemo.reportPerformanceFor("starting at", l);
        Pseudograph<Object, DefaultEdge> pseudograph = new Pseudograph<Object, DefaultEdge>(DefaultEdge.class);
        Object object2 = object = new Object();
        pseudograph.addVertex(object);
        int n = 10000;
        int n2 = 200;
        int n3 = n * (1 + n2);
        System.out.println("\nallocating graph with " + n3 + " elements (may take a few tens of seconds)...");
        for (int i = 0; i < n; ++i) {
            object2 = new Object();
            pseudograph.addVertex(object2);
            for (int j = 0; j < n2; ++j) {
                pseudograph.addEdge(object, object2);
            }
            object = object2;
        }
        PerformanceDemo.reportPerformanceFor("graph allocation", l);
        l = System.currentTimeMillis();
        CrossComponentIterator crossComponentIterator = new BreadthFirstIterator(pseudograph);
        while (crossComponentIterator.hasNext()) {
            crossComponentIterator.next();
        }
        PerformanceDemo.reportPerformanceFor("breadth traversal", l);
        l = System.currentTimeMillis();
        crossComponentIterator = new DepthFirstIterator(pseudograph);
        while (crossComponentIterator.hasNext()) {
            crossComponentIterator.next();
        }
        PerformanceDemo.reportPerformanceFor("depth traversal", l);
        System.out.println("\nPaused: graph is still in memory (to check mem consumption).");
        System.out.print("press enter to free memory and finish...");
        try {
            System.in.read();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("done.");
    }

    private static void reportPerformanceFor(String string, long l) {
        double d = (double)(System.currentTimeMillis() - l) / 1000.0;
        double d2 = (double)PerformanceDemo.usedMemory() / 1048576.0;
        d2 = (double)Math.round(d2 * 100.0) / 100.0;
        System.out.println(string + " (" + d + " sec, " + d2 + "MB)");
    }

    private static long usedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }
}

