% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/materialmodifier.R
\name{im_save}
\alias{im_save}
\title{Save an image to disk}
\usage{
im_save(im, name, path, format = "png", quality = 0.95)
}
\arguments{
\item{im}{An image.}

\item{name}{Name of the image file.}

\item{path}{The image is saved in this direcory. For example, path = getwd()}

\item{format}{Image format. Either "jpg", "png", "tiff", or "bmp". Default is "png".}

\item{quality}{(jpg only) default is 0.95. Higher quality means less compression.}
}
\value{
No return value, called for side effects.
}
\description{
Save an image to disk
}
\examples{
\dontrun{
# face.png is saved to a path (if a path is specified)
im_save( face, path = NULL )
# img.png is saved to a path (if a path is specified)
im_save( face, name = "img", path = NULL )
# myimage.jpg is saved to a path (if a path is specified)
im_save( face, name = "myimage", path = NULL, format = "jpg" )
}
}
