% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4c.biviph.R
\name{biviph}
\alias{biviph}
\title{Constructor function for bivariate inhomogeneous phase-type distributions}
\usage{
biviph(
  bivph = NULL,
  gfun = NULL,
  gfun_pars = NULL,
  alpha = NULL,
  S11 = NULL,
  S12 = NULL,
  S22 = NULL,
  dimensions = c(3, 3)
)
}
\arguments{
\item{bivph}{An object of class \linkS4class{bivph}.}

\item{gfun}{Vector of inhomogeneity transforms.}

\item{gfun_pars}{List of parameters for the inhomogeneity functions.}

\item{alpha}{A probability vector.}

\item{S11}{A sub-intensity matrix.}

\item{S12}{A matrix.}

\item{S22}{A sub-intensity matrix.}

\item{dimensions}{The dimensions of the bivariate phase-type (if no parameters are provided).}
}
\value{
An object of class \linkS4class{biviph}.
}
\description{
Constructor function for bivariate inhomogeneous phase-type distributions
}
\examples{
under_bivph <- bivph(dimensions = c(3, 3))
biviph(under_bivph, gfun = c("weibull", "pareto"), gfun_pars = list(c(2), c(3)))
}
