% Generated by roxygen2 (4.0.2): do not edit by hand
\name{weight.pls}
\alias{weight.pls}
\title{Partial Least Squares and other iterative two-stage weight algorithms}
\usage{
weight.pls(S, model, W.mod, outerEstimators = NULL,
  innerEstimator = inner.path, ..., convCheck = convCheck.absolute,
  tol = 1e-05, iter = 100, validateInput = TRUE)
}
\arguments{
\item{S}{Covariance matrix of the data.}

\item{model}{There are two options for this argument: 1. lavaan script or lavaan parameter
table, or 2. a list containing three matrices
\code{inner}, \code{reflective}, and \code{formative} defining the free regression paths
in the model.}

\item{W.mod}{An optional numeric matrix representing the weight patter and starting weights
(i.e. the how the indicators are combined to form the composite variables). If this argument is not specified,
the weight patter is defined based on the relationships in the \code{reflective} and  \code{formative}
elements of \code{model}.}

\item{outerEstimators}{A function or a list of functions used for outer estimation. If
the value of this parameter is a function, the same function is applied to all
composites. If the value of the parameter is a list, the composite \code{n} is estimated
with the estimator in the \code{n}th position in the list. If this argument is
\code{NULL} the starting weights specified in \code{W.mod} will be returned. The default is \code{\link{outer.modeA}}
(PLS Mode A estimation).}

\item{innerEstimator}{A function used for inner estimation. Setting this argument to
\code{null} will use identity matrix as inner estimates and causes the algorithm to converge
after the first iteration. This is useful when using
\code{\link{outer.fixedWeights}} or some other outer estimation function that
does not use inner estimation results. The default is \code{\link{inner.path}}
(PLS path weighting scheme).}

\item{...}{All other arguments are passed through to \code{outerEstimators} and \code{innerEstimator}.}

\item{convCheck}{A function that takes the old and new weight matrices and
returns a scalar that is compared against \code{tol} to check for convergence. The default
function calculates the differences between each cell of old and new weights and returns the largest
absolute difference.}

\item{tol}{Decimal value indicating the tolerance criterion for the
iterations.}

\item{iter}{An integer indicating the maximum number of iterations.}

\item{validateInput}{A boolean indicating whether the validity of the parameter values should be tested.}
}
\value{
An object of class \code{"matrixplsweights"}, which is a matrix containing the weights with the following attributes:

\item{iterations}{Number of iterations performed}

\item{converged}{A boolean indicating if the algorithm converged}

\item{history}{A data.frame containing the weights for each iteration}
}
\description{
Estimates a weight matrix using Partial Least Squares or a related algorithm.
}
\details{
\code{weight.pls} calculates indicator weights by calling the
\code{innerEstimator} and \code{outerEstimators} iteratively until either the convergence criterion or
maximum number of iterations is reached and provides the results in a matrix.


Model can be specified in the lavaan format or the native matrixpls format.
The native model format is a list of three binary matrices, \code{inner}, \code{reflective},
and \code{formative} specifying the free parameters of a model: \code{inner} (\code{l x l}) specifies the
regressions between composites, \code{reflective} (\code{k x l}) specifies the regressions of observed
data on composites, and \code{formative} (\code{l x k}) specifies the regressions of composites on the
observed data. Here \code{k} is the number of observed variables and \code{l} is the number of composites.

If the model is specified in lavaan format, the native
format model is derived from this model by assigning all regressions between latent
variables to \code{inner}, all factor loadings to \code{reflective}, and all regressions
of latent variables on observed variables to \code{formative}. Regressions between
observed variables and all free covariances are ignored. All parameters that are
specified in the model will be treated as free parameters. If model is specified in
lavaan syntax, the model that is passed to the \code{parameterEstimator} will be that
model and not the native format model.

The original papers about Partial Least Squares, as well as many of the current PLS
implementations, impose restrictions on the matrices \code{inner},
\code{reflective}, and \code{formative}: \code{inner} must be a lower triangular matrix,
\code{reflective} must have exactly one non-zero value on each row and must have at least
one non-zero value on each column, and \code{formative} must only contain zeros.
Some PLS implementations allow \code{formative} to contain non-zero values, but impose a
restriction that the sum of \code{reflective} and \code{t(formative)} must satisfy
the original restrictions of \code{reflective}. The only restrictions that matrixpls
imposes on \code{inner}, \code{reflective}, and \code{formative} is that these must be
binary matrices and that the diagonal of \code{inner} must be zeros.


The argument \code{W.mod} is a (\code{l x k}) matrix that indicates
how the indicators are combined to form the composites. The original papers about
Partial Least Squares as well as all current PLS implementations define this as
\code{t(reflective) | formative}, which means that the weight patter must match the
model specified in \code{reflective} and \code{formative}. Matrixpls does not
require that \code{W.mod} needs to match \code{reflective} and \code{formative}, but
accepts any numeric matrix. If this argument is not specified, \code{W.mod} is
defined as \code{t(reflective) | formative}.
}
\seealso{
Inner estimators: \code{\link{inner.path}}; \code{\link{inner.centroid}}; \code{\link{inner.factor}}; \code{\link{inner.GSCA}}; \code{\link{inner.identity}}

Outer estimators: \code{\link{outer.modeA}}; \code{\link{outer.modeB}}; \code{\link{outer.GSCA}}; \code{\link{outer.factor}}; \code{\link{outer.fixedWeights}}

Convergence checks: \code{\link{convCheck.absolute}}, \code{\link{convCheck.square}}, and \code{\link{convCheck.relative}}.

Other Weight algorithms: \code{\link{weight.fixed}};
  \code{\link{weight.optim}}
}

