% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixpls.crossvalidate.R
\name{matrixpls.crossvalidate}
\alias{matrixpls.crossvalidate}
\title{Cross-validation of predictions from matrixpls results}
\usage{
matrixpls.crossvalidate(data, model, ..., predictFun = stats::predict,
  nGroup = 4, blindfold = FALSE, imputationFun = NULL)
}
\arguments{
\item{data}{Matrix or data frame containing the raw data.}

\item{model}{There are two options for this argument: 1. lavaan script or lavaan parameter
table, or 2. a list containing three matrices
\code{inner}, \code{reflective}, and \code{formative} defining the free regression paths
in the model.}

\item{...}{All other arguments are passed through to \code{\link{matrixpls}} and \code{predictFun}.}

\item{predictFun}{The function used to calculate the predictions.}

\item{nGroup}{The number of groups to divide the data into.}

\item{blindfold}{Whether blindfolding should be used instead of holdout sample cross-validation.}

\item{imputationFun}{The function used to impute missing data before blindfold prediction. 
If \code{NULL}, simple mean substitution is used.}
}
\value{
A matrix containing predictions calculated with cross-validation.
}
\description{
\code{matrixpls.crossvalidate} Calculates cross-validation predictions using \code{matrixpls}.
}
\details{
In cross-validation, some elements of the data matrix are set to missing and then
predicted based on the remaining observations. The process is repeated until all elements
of the data have been predicted. 

Cross-validation is typically applied by dividing the data into two groups, the training
sample and the validation sample. The prediction model is calculated based on the 
training sample and used to calculate predictions for the validation sample.

In blindfolding, the data are not omitted case wise, but elements of the data are omitted
diagonally. After this, imputation is applied to missing data and the prediction model
is calibrated with the dataset containing also the imputations. The imputed values are then 
predicted with the model.
}

