% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/student.R
\name{rmatrixt}
\alias{rmatrixt}
\title{Matrix t sampler}
\usage{
rmatrixt(n, nu, M, U, V, checkSymmetry = TRUE, keep = TRUE)
}
\arguments{
\item{n}{sample size, a positive integer}

\item{nu}{degrees of freedom, a positive number}

\item{M}{mean matrix, without constraints}

\item{U}{columns covariance matrix, a positive semidefinite matrix of order equal
to \code{nrow(M)}}

\item{V}{rows covariance matrix, a positive semidefinite matrix of order equal
to \code{ncol(M)}}

\item{checkSymmetry}{logical, whether to check the symmetry of \code{U} and \code{V}}

\item{keep}{logical, whether to return an array with class \pkg{\link[keep]{keep}}}
}
\value{
A numeric three-dimensional array;
simulations are stacked along the third dimension (see example).
}
\description{
Samples the matrix t-distribution.
}
\note{
When \code{p=1} and \code{V=nu} or when \code{m=1} and \code{U=nu}, the
distribution is the multivariate t-distribution.
}
\examples{
nu <- 4
m <- 2
p <- 3
M <- matrix(1, m, p)
U <- toeplitz(m:1)
V <- toeplitz(p:1)
Tsims <- rmatrixt(10000, nu, M, U, V)
dim(Tsims) # 2 3 10000
apply(Tsims, 1:2, mean) # approximates M
vecTsims <- t(apply(Tsims, 3, function(X) c(t(X))))
round(cov(vecTsims), 1) # approximates 1/(nu-2) * kronecker(U,V)
## the `keep` class is nice when m=1 or p=1:
Tsims <- rmatrixt(2, nu, M=1:3, U=diag(3), V=1)
Tsims[,,1] # dimensions 3 1
# without `keep`, dimensions are lost:
rmatrixt(2, nu, M=1:3, U=diag(3), V=1, keep=FALSE)[,,1]
}
