#' Energy consumption in the UK in 2000
#'
#' A dataset containing approximations to
#' some of the energy flows in the UK in the year 2000.
#' These data first appeared as the example in
#' Figures 3, 7, and 11 of
#' M.K. Heun, A. Owen, and P.E. Brockway. 2018.
#' A physical supply-use table framework for energy analysis on the energy conversion chain.
#' Applied Energy,
#' Vol. 226,
#' pp. 1134-1162.
#'
#' @format A data frame with 36 rows and 7 variables:
#' \describe{
#'   \item{Country}{country, GB (Great Britain, only one country)}
#'   \item{Year}{year, 2000 (only one year)}
#'   \item{Ledger.side}{Supply or Consumption}
#'   \item{Flow.aggregation.point}{tells where each row should be aggregated}
#'   \item{Flow}{the Industry or Sector involved in this flow}
#'   \item{Product}{the energy product involved in this flow}
#'   \item{E.ktoe}{magnitude of the energy flow in ktoe}
#' }
#' @source \doi{10.1016/j.apenergy.2018.05.109}
"UKEnergy2000"
