% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tau.R
\name{associate}
\alias{associate}
\title{Associate pairwise vectors form one or two sets}
\usage{
associate(m1, m2, parallel = FALSE, n_cor = 1, estimator = "values", d1,
  d2, p11 = 0, p01 = 0, p10 = 0)
}
\arguments{
\item{m1, m2}{matrices whose columns are to be correlated. If no estimation
calculations are needed, default is NA.}

\item{parallel}{should the computations for associating the matrices be done
in parallel? Default is FALSE}

\item{n_cor}{number of cores to be used if the computation is run in
parallel. Default is 1}

\item{estimator}{string indicating how the parameters \eqn{p_{11}}, \eqn{p_{01}},
\eqn{p_{10}}, \eqn{p_{00}} are to be estimated. The default is 'values', which
indicates that they are estimated based on the entries of x and y. If
estimates=='mean', each \eqn{p_{ij}} is estimated as the mean of all pairs of
column vectors in \eqn{m_1}, and of \eqn{m_2} if needed. If estimates=='own', the
\eqn{p_{ij}}'s must be given as arguments.}

\item{d1, d2}{sets of vectors used to estimate \eqn{p_{ij}} parameters. If just one
set is needed set \eqn{d_1}=\eqn{d_2}.}

\item{p11}{probability that a bivariate observation is of the type (m,n),
where m,n>0.}

\item{p01}{probability that a bivariate observation is of the type (0,n),
where n>0.}

\item{p10}{probability that a bivariate observation is of the type (n,0),
where n>0.}
}
\value{
matrix of correlation values.
}
\description{
Given two matrices \eqn{m_1} and \eqn{m_2}, computes all pairwise correlations of each
vector in \eqn{m_1} with each vector in \eqn{m_2}. Thanks to the package foreach,
computation can be done in parallel using the desired number of cores.
}
\details{
To find pairwise monotonic associations of vectors within one set \eqn{m}, run
associate(\eqn{m},\eqn{m}). Note that the values on the diagonal will not be necessarely
1 if the vectors contain 0's, as it can be seen by the formula \eqn{p_{11}^2 t_{11} + 2 * (p_{00} p_{11} - p_{01} p_{10})}
}
\examples{
v1=c(0,0,10,0,0,12,2,1,0,0,0,0,0,1)
v2=c(0,1,1,0,0,0,1,1,64,3,4,2,32,0)
associate(v1,v2)
m1=matrix(c(0,0,10,0,0,12,2,1,0,0,0,0,0,1,1,64,3,4,2,32,0,0,43,54,3,0,0,3,20,1),6)
associate(m1,m1)
m2=matrix(c(0,1,1,0,0,0,1,1,64,3,4,2,32,0,0,43,54,3,0,0,3,20,10,0,0,12,2,1,0,0),6)
associate(m1,m2)
}
