% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combining.R
\name{combine}
\alias{combine}
\title{combine}
\usage{
combine(m1, m2, sl = 0.05, parallel = FALSE, n_cor = 1,
  estimator = "values", d1, d2, p11 = 0, p01 = 0, p10 = 0)
}
\arguments{
\item{m1, m2}{matrices whose columns are to be correlated. If no estimation
calculations are needed, default is NA.}

\item{sl}{level of significance for testing the null hypothesis. Default is
0.05.}

\item{parallel}{should the computations for associating the matrices be done
in parallel? Default is FALSE}

\item{n_cor}{number of cores to be used if the computation is run in
parallel. Default is 1}

\item{estimator}{string indicating how the parameters \eqn{p_{11}}, \eqn{p_{01}},
\eqn{p_{10}}, \eqn{p_{00}} are to be estimated. The default is 'values', which
indicates that they are estimated based on the entries of x and y. If
estimates=='mean', each \eqn{p_{ij}} is estimated as the mean of all pairs of
column vectors in \eqn{m_1}, and of \eqn{m_2} if needed. If estimates=='own', the
\eqn{p_{ij}}'s must be given as arguments.}

\item{d1, d2}{sets of vectors used to estimate \eqn{p_{ij}} parameters. If just one
set is needed set \eqn{d_1}=\eqn{d_2}.}

\item{p11}{probability that a bivariate observation is of the type (m,n),
where m,n>0.}

\item{p01}{probability that a bivariate observation is of the type (0,n),
where n>0.}

\item{p10}{probability that a bivariate observation is of the type (n,0),
where n>0.}
}
\value{
matrix of combined association values and p-values.
}
\description{
Designed to combine the matrix of correlation values with the matrix of
p-values so that in the cases when the null hypothesis cannot be rejected
with a level of confidence indicated by the significance, the correlation is
set to zero. Thanks to the package foreach, computation can be done in
parallel using the desired number of cores.
}
\details{
To test pairwise monotonic associations of vectors within one set \eqn{m}, run
combine(\eqn{m},\eqn{m}). Note that the values on the diagonal will not be necessarily
significant if the vectors contain 0's, as it can be seen by the formula
\eqn{p_{11}^2 t_{11} + 2 * (p_{00} p_{11} - p_{01} p_{10})}. The formula for the
variance of the estimator proposed by Pimentel(2009) does not apply in case
\eqn{p_{11}}, \eqn{p_{01}},\eqn{p_{10}}, \eqn{p_{00}} attain the values 0 or 1. In these cases the R
function cor.test is used. Note that while independence implies that the
estimator is 0, if the estimator is 0, it does not imply that the vectors are
independent.
}
