% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_p.R
\name{mle_p}
\alias{mle_p}
\title{MLE of p for fixed e}
\usage{
mle_p(
  tab,
  e = 0.002,
  interval = c(0, 1),
  tol = 0.000001,
  check_boundary = FALSE
)
}
\arguments{
\item{tab}{Dataset of read counts as 3d array of size 3x3x2, genotype in first sample x genotype in second sample x allele in read.}

\item{e}{Assumed value for the sequencing error rate}

\item{interval}{Interval to which each parameter should be constrained}

\item{tol}{Tolerance for convergence}

\item{check_boundary}{If TRUE, explicitly check the boundaries of \code{interval}.}
}
\value{
A single numeric value, the MLE of \code{p}, with the log likelihood as an attribute.
}
\description{
Calculate the MLE of the contaminant probability p for a fixed value of the sequencing error rate e.
}
\examples{
data(mbmixdata)
mle_p(mbmixdata, e=0.002)

}
