% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsc.setting.R
\name{tsc.setting}
\alias{tsc.setting}
\title{Specification of time series components}
\usage{
tsc.setting(Ytrain, mu, rho, S, vrho, lambda)
}
\arguments{
\item{Ytrain}{The multivariate time series to be modeled.}

\item{mu}{A vector of logic values indicating whether to include a local trend for each target series.}

\item{rho}{A vector of numerical values taking values in \eqn{[0,1]}, describing the learning rates at which the local trend is updated for each target series. The value \eqn{0} in the \eqn{j}-th entry indicates that the \eqn{j}-th target series does not include slope of trend.}

\item{S}{A vector of integer values representing the number of seasons to be modeled for each target series. The value \eqn{0} in the \eqn{j}-th entry indicates that the \eqn{j}-th target series does not include the seasonal component.}

\item{vrho}{A vector of numerical values taking values in \eqn{[0,1]}, describing a damping factor for each target series. The value \eqn{0} in the \eqn{j}-th entry indicates that the \eqn{j}-th target series does not include the cycle component.}

\item{lambda}{A vector of numerical values, whose entries equal to \eqn{2\pi/q} with \eqn{q} being a period such that \eqn{0<\lambda<\pi}, describing the frequency.}
}
\value{
An object of the SSModel class.
}
\description{
Specify three time series components for the MBSTS model: the generalized linear trend component, the seasonal component, and the cycle component.
}
\examples{
#Two target series
Y<-as.matrix(simdata[,1:2])

#split dataset into training set and test set
n=dim(Y)[1]
ntrain=n-5
Ytrain<-Y[1:ntrain,]
 
#Specify time series components
STmodel<-tsc.setting(Ytrain,mu=c(1,1),rho=c(0.6,0.8),S=c(12,0),vrho=c(0,0.99),
                                                            lambda=c(0,pi/50))
}
\references{
\Qiu2018

\Ning2021

\Jammalamadaka2019
}
\author{
Jinwen Qiu \email{qjwsnow_ctw@hotmail.com} Ning Ning \email{patricianing@gmail.com}
}
