% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_summary.R
\name{mc_summary}
\alias{mc_summary}
\title{Compute summary statistics for an mcnode object}
\usage{
mc_summary(
  mcmodule = NULL,
  mc_name = NULL,
  keys_names = NULL,
  data = NULL,
  mcnode = NULL,
  sep_keys = TRUE,
  digits = NULL
)
}
\arguments{
\item{mcmodule}{An mcmodule object containing the node to summarize}

\item{mc_name}{Character string specifying the name of the mcnode in the module}

\item{keys_names}{Vector of column names to use as keys for grouping (default: NULL)}

\item{data}{Optional data frame containing the input data (default: NULL)}

\item{mcnode}{Optional mcnode object to summarize directly (default: NULL)}

\item{sep_keys}{Logical; if TRUE, keeps keys in separate columns (default: TRUE)}

\item{digits}{Integer indicating number of significant digits for rounding (default: NULL)}
}
\value{
A data frame containing summary statistics with columns:
\itemize{
\item mc_name: Name of the mcnode
\item keys: Grouping variables (if sep_keys=FALSE) or individual key columns (if sep_keys=TRUE)
\item Summary statistics including:
\itemize{
\item mean: Average value
\item sd: Standard deviation
\item Various quantiles (2.5\%, 25\%, 50\%, 75\%, 97.5\%)
}
}
}
\description{
Compute summary statistics for an mcnode object
}
\details{
This function can be called in two ways:
\enumerate{
\item By providing an mcmodule and mc_name
\item By providing data and mcnode directly
}
}
\examples{
# Use with mcmodule
summary_basic <- mc_summary(imports_mcmodule, "w_prev")

# Using custom keys and rounding
summary_custom <- mc_summary(imports_mcmodule, "w_prev",
  keys_names = c("origin"),
  digits = 3
)

# Use with data and mcnode
w_prev <- imports_mcmodule$node_list$w_prev$mcnode
summary_direct <- mc_summary(
  data = imports_data,
  mcnode = w_prev,
  sep_keys = FALSE
)
}
