% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blandAltman.R
\name{blandAltman}
\alias{blandAltman}
\title{Calculate Statistics for Bland-Altman}
\usage{
blandAltman(x, y, sid = NULL, type1 = 3, type2 = 5, conf.level = 0.95)
}
\arguments{
\item{x}{(\code{numeric})\cr reference method.}

\item{y}{(\code{numeric})\cr test method.}

\item{sid}{(\code{numeric} or \code{string}) sample id.}

\item{type1}{(\code{integer})\cr specifying a specific difference for absolute difference, default is 3.}

\item{type2}{(\code{integer})\cr specifying a specific difference for relative difference, default is 5.}

\item{conf.level}{(\code{numeric})\cr significance level for two side, default is 0.95.}
}
\value{
A object with \code{\link{BAsummary}} class that contains the BlandAltman analysis.
\itemize{
\item \code{data} a data frame contains the raw data from the input.
\item \code{stat} a list contains the summary table (\code{tab}) of Bland-Altman analysis,
vector (\code{absolute_diff}) of absolute difference and vector (\code{relative_diff})
of relative difference.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Calculate the Bland-Altman related statistics with specific difference type,
such as difference, limited of agreement and confidence interval. And the outlier
detecting function and graphic function will get the difference result from this.
}
\examples{
data("platelet")
blandAltman(x = platelet$Comparative, y = platelet$Candidate)

# with sample id as input sid
blandAltman(x = platelet$Comparative, y = platelet$Candidate, sid = platelet$Sample)

# Specifiy the type for difference
blandAltman(x = platelet$Comparative, y = platelet$Candidate, type1 = 1, type2 = 4)
}
\seealso{
\code{\link[=h_difference]{h_difference()}} to see the type details.
}
