/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.data;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import multidendrograms.data.ProximityPair;
import multidendrograms.errors.IncompatibleFileError;
import multidendrograms.initial.InitialProperties;
import multidendrograms.initial.Language;
import multidendrograms.initial.LogManager;

public class ReadTxt {
    private final String fileName;
    private final LinkedList<String[]> dataList;
    private int numElements = 0;
    private String[] names = null;
    private LinkedList<ProximityPair<String>> data;
    private double missingValue = InitialProperties.getMissingValue();

    /*
     * WARNING - void declaration
     */
    public ReadTxt(String string) throws Exception {
        this.fileName = string;
        this.dataList = this.saveInMemory();
        int n = this.dataList.size();
        int n2 = this.dataList.get(0).length;
        if (n2 != 3) {
            this.data = this.readMatrix();
        } else if (n != 3 && n != 4) {
            this.data = this.readList();
        } else {
            void var5_12;
            LinkedList<ProximityPair<String>> linkedList;
            LinkedList<ProximityPair<String>> linkedList2;
            boolean bl2;
            try {
                bl2 = true;
                linkedList2 = this.readList();
            }
            catch (Exception exception) {
                bl2 = false;
                linkedList2 = null;
            }
            try {
                boolean bl = true;
                linkedList = this.readMatrix();
            }
            catch (Exception exception) {
                boolean proximityPair = false;
                linkedList = null;
            }
            if (bl2 && var5_12 != false) {
                String string2 = Language.getLabel(10);
                JOptionPane.showMessageDialog(null, string2, "Warning", 2);
                this.data = linkedList2;
            } else if (bl2) {
                this.data = linkedList2;
            } else if (var5_12 != false) {
                this.data = linkedList;
            } else {
                throw new IncompatibleFileError(Language.getLabel(11));
            }
        }
        if (LogManager.LOG.getLevel().equals(Level.FINER)) {
            LogManager.LOG.finer("---------- DATA ----------");
            for (ProximityPair proximityPair : this.data) {
                LogManager.LOG.finer(proximityPair.getElement1() + "\t" + proximityPair.getElement2() + "\t" + proximityPair.getProximity());
            }
        }
    }

    public int getNumElements() {
        return this.numElements;
    }

    public LinkedList<ProximityPair<String>> getData() {
        return this.data;
    }

    private LinkedList<String[]> saveInMemory() throws IncompatibleFileError, IOException {
        LinkedList<String[]> linkedList = new LinkedList<String[]>();
        File file = new File(this.fileName);
        if (!file.exists()) {
            throw new IOException(Language.getLabel(106) + ": '" + this.fileName + "'");
        }
        int n = 0;
        try {
            String string;
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).equalsIgnoreCase("") || string.startsWith("#")) continue;
                linkedList.add(this.readLine(file, ++n, string));
            }
            bufferedReader.close();
            if (n == 0) {
                throw new IncompatibleFileError(Language.getLabel(103) + " '" + file.getName() + "'");
            }
        }
        catch (IOException iOException) {
            throw new IOException(Language.getLabel(127) + " '" + this.fileName + "' " + Language.getLabel(128) + " " + n);
        }
        return linkedList;
    }

    private String[] readLine(File file, int n, String string) throws IncompatibleFileError {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,;|\t\n");
        int n2 = stringTokenizer.countTokens();
        if (n2 < 1) {
            throw new IncompatibleFileError(Language.getLabel(104) + " " + n + " " + Language.getLabel(105) + " '" + file.getName() + "'");
        }
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    private LinkedList<ProximityPair<String>> readList() throws Exception {
        void var10_18;
        int n;
        Object object22;
        LinkedList<ProximityPair<String>> linkedList = new LinkedList<ProximityPair<String>>();
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int n2 = 0;
        int n3 = 1;
        Double d = null;
        for (Object object22 : this.dataList) {
            String string = object22[0];
            String string2 = object22[1];
            try {
                d = Double.parseDouble(object22[2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IncompatibleFileError(Language.getLabel(13) + " " + n3 + ". " + Language.getLabel(14));
            }
            if (!hashtable.containsKey(string)) {
                hashtable.put(string, n2++);
            }
            if (!hashtable.containsKey(string2)) {
                hashtable.put(string2, n2++);
            }
            linkedList.add(new ProximityPair<String>(string, string2, d));
            ++n3;
        }
        this.numElements = hashtable.size();
        this.names = new String[this.numElements];
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            this.names[((Integer)hashtable.get((Object)object22)).intValue()] = object22 = (String)enumeration.nextElement();
        }
        object22 = new double[this.numElements][this.numElements];
        for (int i = 0; i < this.numElements; ++i) {
            for (int j = 0; j < this.numElements; ++j) {
                object22[i][j] = (String)Double.NaN;
            }
        }
        LinkedList<ProximityPair<String>> linkedList2 = new LinkedList<ProximityPair<String>>();
        for (ProximityPair proximityPair : linkedList) {
            n = (Integer)hashtable.get(proximityPair.getElement1());
            int n4 = (Integer)hashtable.get(proximityPair.getElement2());
            d = proximityPair.getProximity();
            if (n > n4) {
                int n5 = n;
                n = n4;
                n4 = n5;
            }
            if (!Double.isNaN((double)object22[n][n4])) continue;
            object22[n][n4] = (String)((Object)d);
            linkedList2.add(new ProximityPair<String>(this.names[n], this.names[n4], d));
        }
        boolean bl = true;
        boolean i = false;
        while (var10_18 < this.numElements) {
            if (Double.isNaN((double)object22[var10_18][var10_18])) {
                linkedList2.add(new ProximityPair<String>(this.names[var10_18], this.names[var10_18], Double.NaN));
            }
            for (n = var10_18 + true; n < this.numElements; ++n) {
                if (!Double.isNaN((double)object22[var10_18][n])) continue;
                if (bl) {
                    String string = Language.getLabel(15) + ": " + this.missingValue;
                    LogManager.LOG.warning(string);
                    bl = false;
                }
                object22[var10_18][n] = (String)this.missingValue;
                linkedList2.add(new ProximityPair<String>(this.names[var10_18], this.names[n], this.missingValue));
            }
            ++var10_18;
        }
        return linkedList2;
    }

    private LinkedList<ProximityPair<String>> readMatrix() throws Exception {
        boolean bl;
        boolean bl2;
        LinkedList<ProximityPair<String>> linkedList = null;
        Iterator<String[]> iterator = this.dataList.iterator();
        int n = this.dataList.size();
        int n2 = Math.max(this.dataList.get(0).length, this.dataList.get(n - 1).length);
        int n3 = 1;
        if (n < n2) {
            bl2 = true;
            this.numElements = n;
            this.names = new String[this.numElements];
            bl = this.dataList.get(0).length == 2;
        } else {
            bl2 = false;
            this.numElements = n2;
            if (n > n2) {
                this.names = (String[])iterator.next();
                ++n3;
                bl = this.dataList.get(1).length == 1;
            } else {
                this.names = new String[this.numElements];
                for (int i = 1; i <= this.numElements; ++i) {
                    this.names[i - 1] = Integer.toString(i);
                }
                bl = this.dataList.get(0).length == 1;
            }
        }
        linkedList = this.readTable(bl2, bl, n2, n3, iterator);
        return linkedList;
    }

    private LinkedList<ProximityPair<String>> readTable(boolean bl, boolean bl2, int n, int n2, Iterator<String[]> iterator) throws IncompatibleFileError {
        int n3;
        String[] stringArray;
        double[][] dArray = new double[this.numElements][this.numElements];
        int n4 = 0;
        while (iterator.hasNext()) {
            if (!bl && n4 >= n) {
                throw new IncompatibleFileError(Language.getLabel(100));
            }
            stringArray = iterator.next();
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (bl && n3 == 0) {
                    this.names[n4] = stringArray[0];
                    continue;
                }
                if (bl && n3 == n4 + 1 || !bl && n3 == n4) {
                    dArray[n4][n4] = Double.parseDouble(stringArray[n3]);
                    continue;
                }
                if (bl) {
                    try {
                        dArray[n4][n3 - 1] = Double.parseDouble(stringArray[n3]);
                        if (!bl2) continue;
                        dArray[n3 - 1][n4] = dArray[n4][n3 - 1];
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IncompatibleFileError(Language.getLabel(125));
                    }
                }
                if (bl) continue;
                try {
                    dArray[n4][n3] = Double.parseDouble(stringArray[n3]);
                    if (!bl2) continue;
                    dArray[n3][n4] = dArray[n4][n3];
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IncompatibleFileError(Language.getLabel(125));
                }
            }
            ++n2;
            ++n4;
        }
        stringArray = new LinkedList();
        for (n3 = 0; n3 < this.numElements; ++n3) {
            stringArray.add(new ProximityPair<String>(this.names[n3], this.names[n3], dArray[n3][n3]));
            for (int i = n3 + 1; i < this.numElements; ++i) {
                if (dArray[n3][i] != dArray[i][n3]) {
                    throw new IncompatibleFileError(Language.getLabel(12));
                }
                stringArray.add(new ProximityPair<String>(this.names[n3], this.names[i], dArray[n3][i]));
            }
        }
        return stringArray;
    }
}

