% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist2sim.R
\name{dist2sim}
\alias{dist2sim}
\title{Transform Distance matrix to Similarity matrix}
\usage{
dist2sim(dist.mat)
}
\arguments{
\item{dist.mat}{distance matrix (squared symmetric matrix)}
}
\value{
similarity matrix
}
\description{
Transform Distance matrix into Similarity matrix. In particular, might be used
to obtain a graph Adjacency matrix from a graph Distance matrix.
}
\examples{
set.seed(123)
x <- matrix(rnorm(100), nrow = 10)
dist.mat <- as.matrix(dist(x))
vizu.mat(dist.mat, "Distance matrix")

sim.mat <- dist2sim(dist.mat)
vizu.mat(sim.mat, "Similarity matrix")

}

