% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_analyses.R
\name{define_analyses}
\alias{define_analyses}
\title{Assess & Save MD-PMS Analyses Definitions}
\usage{
define_analyses(deviceevents, device_level, event_level = NULL,
  exposure = NULL, date_level = "months", date_level_n = 1,
  covariates = "_none_", times_to_calc = NULL, prior = NULL)
}
\arguments{
\item{deviceevents}{A device-events object of class \code{mds_de}}

\item{device_level}{String value indicating the source device variable name
to analyze by.

Example: If the \code{deviceevents} variable column is \code{device_1} where
the source variable name for \code{device_1} is \code{'Device Code'}, specify
\code{device_level='Device Code'}.}

\item{event_level}{String value indicating the source event variable name to
analyze by. Note that \code{event_level} is not matched to \code{exposure}.

Default: \code{NULL} will not analyze by event.

Example: If the \code{deviceevents} variable column is \code{event_1} where
the source variable name for \code{event_1} is \code{'Event Code'}, specify
\code{event_level='Event Code'}.}

\item{exposure}{Optional exposure object of class \code{mds_e}. See details
for how exposure analyses definitions are handled.

Default: \code{NULL} will not consider inclusion of exposure.}

\item{date_level}{String value for the primary date unit to analyze by. Can
be either \code{'months'} or \code{'days'}.

Default: \code{'months'}}

\item{date_level_n}{Numeric value indicating the number of \code{date_level}s
to analyze by.

Default: \code{1}

Example: \code{date_level='months'} and \code{date_level_n=3} indicates
analysis on a quarterly level.}

\item{covariates}{Character vector specifying names of covariates to also
define analyses for. Acceptable names are covariate variable names from
\code{deviceevents}. Analyses will be defined for each unique level of each
covariate. \code{"_none_"} specifies no covariates, while \code{"_all_"}
specifies all covariates from \code{deviceevents}.

Default: \code{"_none_"} specifies no covariates.

Example: \code{"Country"}}

\item{times_to_calc}{Integer value indicating the number of date units
counting backwards from the latest date to define analyses for. If
\code{prior} is specified, \code{times_to_calc} will be ignored.

Default: \code{NULL} will define analyses across all available time.

Example 1: \code{times_to_calc=12} with \code{date_level="months"} and
\code{date_level_n=1} defines analyses for the last year by month.

Example 2: \code{times_to_calc=8} with \code{date_level="months"} and
\code{date_level_n=3} defines analyses for the 2 years by quarter.}

\item{prior}{Future placeholder, currently not used.}
}
\value{
A list of defined analyses of class \code{mds_das}.
Each list item, indexed by a numeric key, defines a set of analyses for a
unique combination of device, event, and covariate level. Each list item is
of the class \code{mds_da}.
Attributes are as follows:
\describe{
  \item{date_level}{Defined value for \code{date_level}}
  \item{date_level_n}{Defined value for \code{date_level_n}}
  \item{device_level}{Defined value for \code{device_level}}
  \item{event_level}{Defined value for \code{event_level}}
  \item{times_to_calc}{Defined value for \code{times_to_calc}}
  \item{prior_used}{Boolean for whether \code{prior} was specified.}
  \item{timestamp}{System time when the analyses were defined.}
}
}
\description{
Define analyses based on an MD-PMS device-event data frame and (optionally)
an MD-PMS exposure data frame.
}
\details{
The analyses definitions will always include rollup levels for each
of \code{device_level}, \code{event_level} (if specified), and
\code{covariates}. These rollup analyses will be indicated by the keyword
'All', while the rollup of all covariates will be called 'Data'.

If \code{exposure} is specified, any available \code{match_levels} will be
used to calculate the appropriate timeframe for analyses. The exception are
the special rollup analyses (see prior paragraph).
}
\examples{
# Device-Events
de <- deviceevent(
  data_frame=maude,
  time="date_received",
  device_hierarchy=c("device_name", "device_class"),
  event_hierarchy=c("event_type", "medical_specialty_description"),
  key="report_number",
  covariates=c("region"),
  descriptors="_all_")
# Exposures
ex <- exposure(
  data_frame=sales,
  time="sales_month",
  device_hierarchy="device_name",
  match_levels="region",
  count="sales_volume")
# Defined Analyses - Simple example
da <- define_analyses(de, "device_name")
# Defined Analyses - Simple example with a quarterly analysis
da <- define_analyses(de, "device_name", date_level_n=3)
# Defined Analyses - Example with event type, exposures, and covariates
da <- define_analyses(de, "device_name", "event_type", ex, covariates="region")

}
