% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_mergeTrees.R
\name{forest_mergeTrees}
\alias{forest_mergeTrees}
\alias{forest_mergeShrubs}
\title{Forest merge functions}
\usage{
forest_mergeTrees(x, byDBHclass = TRUE)

forest_mergeShrubs(x, byHeightclass = TRUE)
}
\arguments{
\item{x}{An object of class \code{\link{forest}}.}

\item{byDBHclass}{Logical flag to indicate that 5-cm tree DBH classes should be kept separated.}

\item{byHeightclass}{Boolean flag to indicate that 10-cm shrub height classes should be kept separated.}
}
\value{
Another \code{\link{forest}} object with merged trees or shrubs, depending on the function.
}
\description{
Functions to merge cohorts of a \code{\link{forest}} object.
}
\details{
Tree DBH classes are defined in 5-cm intervals, whereas shrub height classes are defined in 10-cm intervals.
Tree DBH and shrub height classes are defined up to a specific size (i.e. larger plants are not merged) 
corresponding to 52.5 cm and 90 cm, respectively.
}
\seealso{
\code{\link{spwb}}, \code{\link{forest}},  \code{\link{fordyn}}, \code{\link{summary.forest}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
