% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree2forest.R
\name{tree2forest}
\alias{tree2forest}
\alias{shrub2forest}
\title{Single-cohort forests}
\usage{
tree2forest(
  Species,
  Height,
  LAI = NA,
  N = NA,
  DBH = NA,
  Z50 = NA,
  Z95 = NA,
  CrownRatio = NA,
  FoliarBiomass = NA,
  FuelLoading = NA
)

shrub2forest(
  Species,
  Height,
  LAI = NA,
  Cover = NA,
  Z50 = NA,
  Z95 = NA,
  CrownRatio = NA,
  FoliarBiomass = NA,
  FuelLoading = NA
)
}
\arguments{
\item{Species}{String with species (taxon) name or a non-negative integer for species identity (i.e., 0,1,2,...) matching SpParams.}

\item{Height}{Plant height (cm).}

\item{LAI}{Leaf area index (m2/m2)}

\item{N}{Tree density (ind/ha)}

\item{DBH}{Tree DBH (cm).}

\item{Z50}{Depth (in mm) corresponding to 50\% of fine roots.}

\item{Z95}{Depth (in mm) corresponding to 95\% of fine roots.}

\item{CrownRatio}{Crown ratio (fraction of total height)}

\item{FoliarBiomass}{Standing dry biomass of leaves (kg/m2)}

\item{FuelLoading}{Fine fuel loading (kg/m2)}

\item{Cover}{Percent cover}
}
\value{
An object of class \code{\link{forest}}
}
\description{
Creates a \code{\link{forest}} object with a single plant cohort
}
\examples{

oak_forest <-tree2forest("Quercus ilex", Height= 200, LAI = 2)
oak_forest

}
\seealso{
\code{\link{forest}}, \code{\link{emptyforest}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
