% Generated by roxygen2 (4.0.2): do not edit by hand
\name{expData}
\alias{expData}
\title{Expanded dataset}
\value{
A data frame, resulting from applying \code{\link{neWeight}} or \code{\link{neImpute}} on an original dataset \code{data}.
This data frame has \code{nRep * length(data)} rows, containing all original variables (except the original exposure variable)
and two variables reflecting observed and hypothetical values of the exposure for each observation unit.

These auxiliary variables (\emph{x} and \emph{x*}) are named after the exposure variable and carry integers as suffixes.
Suffixes \code{0} and \code{1} are used for variables whose corresponding parameters in the final natural effect model index natural direct and indirect effects, respectively.

This object also stores some additional attributes, which are used as input for \code{\link{neModel}}, such as
  \item{\code{model}}{the fitted imputation model object}
  \item{\code{data}}{original dataset}
  \item{\code{call}}{the matched call}
  \item{\code{terms}}{the \code{neTerms} (internal class) object used}
  \item{\code{weigths}}{ratio-of-mediator probability weights (only stored if object inherits from class \code{weightData})}
}
\description{
Expanded dataset including either ratio-of-mediator probability weights or imputed nested counterfactual outcomes.
}
\note{
If the weighting-based approach (\code{\link{neWeight}}) is applied, the original outcome values are copied for the nested counterfactual outcomes
and the object stores an additional attribute, \code{"weights"}, containing a vector with ratio-of-mediator probability weights.

If the imputation-based approach (\code{\link{neImpute}}) is applied, the nested counterfactual outcomes are imputed by predictions from the imputation model.

In the former case, this object inherits from classes \code{c("data.frame", "expData", "impData"))}, whereas in the latter case it inherits from classes \code{c("data.frame", "expData", "weightData"))}.
}
\seealso{
\code{\link{neImpute}}, \code{\link{neWeight}}
}

