% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/neWeight.R
\name{neWeight.formula}
\alias{neWeight.formula}
\title{Expand the dataset and calculate ratio-of-mediator probability weights}
\usage{
\method{neWeight}{formula}(object, family, data, FUN = glm, nRep = 5,
  xSampling = c("quantiles", "random"), xFit, percLim = c(0.05, 0.95), ...)
}
\arguments{
\item{object}{a \code{\link[stats]{formula}} object providing a symbolic description of the mediator model (see details).}

\item{family}{a description of the error distribution and link function to be used in the model. Consult the help files of the model-fitting function specified in \code{FUN} for more details on appropriate argument specification.}

\item{data}{data, as matrix or data frame, containing the exposure (and other relevant) variables. Redundant if already specified in call for fitted model specified in \code{object} (see details).}

\item{FUN}{function used to fit model specified in \code{formula}.}

\item{nRep}{number of replications or hypothetical values of the exposure to sample for each observation unit.}

\item{xSampling}{character string indicating how to sample from the conditional exposure distribution.
Possible values are \code{"quantiles"} or \code{"random"} (see details).}

\item{xFit}{an optional fitted object (preferably \code{glm}) for the conditional exposure distribution (see details).}

\item{percLim}{a numerical vector of the form \code{c(lower, upper)} indicating the extreme percentiles to sample when using \code{"quantiles"} as sampling method to sample from the conditional exposure distribution (see details).}

\item{...}{additional arguments (passed to \code{FUN}).}
}
\value{
A data frame of class \code{c("data.frame", "expData", "weightData"))}. See \code{\link{expData}} for its structure.
}
\description{
This function both expands the data along hypothetical exposure values and calculates ratio-of-mediator probability weights.
}
\details{
The calculated weights are ratios of fitted probabilities or probability densities from the distribution of the mediator model.
This model is fitted internally by extracting information from the arguments \code{object}, \code{family}, \code{data}, \code{FUN} and \code{...}.

For mediation model specification via the \code{object} argument, use a \code{\link[stats]{formula}} of the form\cr\code{M ~ X + C1 + C2},
with predictor variables entered in the following prespecified order:
\enumerate{
 \item exposure \code{X}: The first predictor is coded as exposure or treatment.
 \item baseline covariates \code{C}: All remaining predictor variables are automatically coded as baseline covariates.
}

It is important to adhere to this prespecified order to enable \code{neWeight} to create valid pointers to these different types of predictor variables.
This requirement extends to the use of operators different than the \code{+} operator, such as the \code{:} and \code{*} operators (when e.g. adding interaction terms).
For instance, the formula specifications \code{M ~ X * C1 + C2}, \code{M ~ X + C1 + X:C1 + C2} and \code{Y ~ X + X:C1 + C1 + C2} will create identical pointers to the different types of variables,
as the order of the unique predictor variables is identical in all three specifications.

Furthermore, categorical exposures that are not coded as factors in the original dataset, should be specified as factors in the formula,
using the \code{\link[base]{factor}} function, e.g. \code{M ~ factor(X) + C1 + C2}.
Quadratic, cubic or other polynomial terms can be included as well, by making use of the \code{\link[base]{I}} function or by using the \code{\link[stats]{poly}} function.
For instance, \code{M ~ X + I(X^2) + C1 + C2} and \code{M ~ poly(X, 2, raw = TRUE) + C1 + C2} are equivalent and result in identical pointers to the different types of variables.

The command \code{terms(object, "vartype")} (with \code{object} replaced by the name of the resulting expanded dataset) can be used to check whether valid pointers have been created.

The type of mediator model can be defined by specifying an appropriate model-fitting function via the \code{FUN} argument (its default is \code{\link[stats]{glm}}).
This method can only be used with model-fitting functions that require a \code{formula} argument.

In contrast to imputation models with categorical exposures, additional arguments need to be specified if the exposure is continuous.
All of these additional arguments are related to the sampling procedure for the exposure.

Whereas the number of replications \code{nRep} for categorical variables equals the number of levels for the exposure coded as a factor (i.e. the number of hypothetical exposure values), the number of desired replications needs to be specified explicitly for continuous exposures.
Its default is 5.

If \code{xFit} is left unspecified, the hypothetical exposure levels are automatically sampled from a linear model for the exposure, conditional on a linear combination of all covariates.
If one wishes to use another model for the exposure, this default model specification can be overruled by referring to a fitted model object in the \code{xFit} argument.
Misspecification of this sampling model does not induce bias in the estimated coefficients and standard errors of the natural effect model.

The \code{xSampling} argument allows to specify how the hypothetical exposure levels should be sampled from the conditional exposure distribution (which is either entered explicitly using the \code{xFit} argument or fitted automatically as described in the previous paragraph).
The \code{"random"} option randomly samples \code{nRep} draws from the exposure distribution, whereas the \code{"quantiles"} option (default) samples \code{nRep} quantiles at equal-sized probability intervals. Only the latter hence yields fixed exposure levels given \code{nRep} and \code{xFit}. \cr\cr
In order to guarantee that the entire support of the distribution is being sampled (which might be a concern if \code{nRep} is chosen to be small), the default lower and upper sampled quantiles are the 5th and 95th percentiles.
The intermittent quantiles correspond to equal-sized probability intervals. So, for instance, if \code{nRep = 4}, then the sampled quantiles will correspond to probabilities 0.05, 0.35, 0.65 and 0.95.
These default 'outer' quantiles can be changed by specifying the \code{percLim} argument accordingly. By specifying \code{percLim = NULL}, the standard quantiles will be sampled (e.g., 0.2, 0.4, 0.6 and 0.8 if \code{nRep = 4}).
}
\examples{
data(UPBdata)

## example using glm
weightData <- neWeight(negaff ~ att + gender + educ + age,
                       data = UPBdata, nRep = 2)

## example using vglm (yielding identical results as with glm)
library(VGAM)
weightData2 <- neWeight(negaff ~ att + gender + educ + age,
                        family = gaussianff, data = UPBdata, nRep = 2, FUN = vglm)
}
\seealso{
\code{\link{neWeight.default}}, \code{\link{expData}}
}

