% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod.h.R
\name{mod}
\alias{mod}
\title{Moderation}
\usage{
mod(data, dep, mod, pred, estMethod = "standard", bootstrap = 1000,
  test = TRUE, ci = FALSE, ciWidth = 95, simpleSlopeEst = FALSE,
  simpleSlopePlot = FALSE)
}
\arguments{
\item{data}{the data as a data frame}

\item{dep}{a string naming the dependent variable}

\item{mod}{a string naming the moderator variable}

\item{pred}{a string naming the predictor variable}

\item{estMethod}{\code{'standard'} (default), or \code{'bootstrap'}, the 
estimation method to use}

\item{bootstrap}{a number between 1 and 100000 (default: 1000) specifying 
the number of  samples that need to been drawn in the bootstrap method}

\item{test}{\code{TRUE} (default) or \code{FALSE}, provide 'Z' and 'p' 
values for the mediation estimates}

\item{ci}{\code{TRUE} or \code{FALSE} (default), provide a confidence 
interval for the mediation estimates}

\item{ciWidth}{a number between 50 and 99.9 (default: 95) specifying the 
confidence interval width that is used as \code{'ci'}}

\item{simpleSlopeEst}{\code{TRUE} or \code{FALSE} (default), provide the 
estimates of the simple slopes.}

\item{simpleSlopePlot}{\code{TRUE} or \code{FALSE} (default), provide a 
plot of the simple slopes.}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$mod} \tab \tab \tab \tab \tab a table containing moderation estimates \cr
  \code{results$simpleSlope$estimates} \tab \tab \tab \tab \tab a table containing the simple slope estimates \cr
  \code{results$simpleSlope$plot} \tab \tab \tab \tab \tab an image \cr
  \code{results$modelSyntax} \tab \tab \tab \tab \tab the lavaan syntax used to fit the moderation model \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$mod$asDF}

\code{as.data.frame(results$mod)}
}
\description{
Simple mediation analysis
}
\examples{
set.seed(1234)
X <- rnorm(10)
M <- rnorm(10)
X_M <- X*M
Y <- 0.7*X + 0.1*M + 4.2*X_M + rnorm(10)
dat <- data.frame(X=X, M=M, Y=Y)   

mod(dat, dep = "Y", pred = "X", mod = "M")

#
#  Moderation Estimates                               
#  -------------------------------------------------- 
#             Estimate    SE        Z        p        
#  -------------------------------------------------- 
#    X           0.951    0.0965     9.86    < .001   
#    M          -0.471    0.0923    -5.10    < .001   
#    X:M         4.185    0.1009    41.50    < .001   
#  -------------------------------------------------- 
# 
# 

}
