% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/print-methods.R
\name{print}
\alias{print}
\alias{print,EL-method}
\alias{print,ELMT-method}
\alias{print,ELT-method}
\alias{print,LM-method}
\alias{print,SummaryEL-method}
\alias{print,SummaryELMT-method}
\alias{print,SummaryELT-method}
\alias{print,SummaryGLM-method}
\alias{print,SummaryLM-method}
\title{Print methods}
\usage{
\S4method{print}{EL}(x, digits = max(3L, getOption("digits") - 3L), ...)

\S4method{print}{ELMT}(x, digits = max(3L, getOption("digits") - 3L), ...)

\S4method{print}{ELT}(x, digits = max(3L, getOption("digits") - 3L), ...)

\S4method{print}{LM}(x, digits = max(3L, getOption("digits") - 3L), ...)

\S4method{print}{SummaryEL}(x, digits = max(3L, getOption("digits") - 3L), ...)

\S4method{print}{SummaryELMT}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)

\S4method{print}{SummaryELT}(x, digits = max(3L, getOption("digits") - 3L), ...)

\S4method{print}{SummaryGLM}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)

\S4method{print}{SummaryLM}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{x}{An object to be printed.}

\item{...}{Further arguments passed to methods.}

\item{digits}{A single integer for the number of significant digits to be
passed to \code{\link[=format]{format()}}.}

\item{signif.stars}{A single logical. If \code{TRUE}, ‘significance stars’ are
printed for each parameter.}
}
\value{
The argument \code{x} (invisibly).
}
\description{
Provides print methods for objects.
}
\examples{
data("precip")
fit <- el_mean(precip, par = 40)
print(fit)
}
\seealso{
\linkS4class{EL}, \linkS4class{ELMT}, \linkS4class{ELT},
\linkS4class{LM}
}
