% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/elt-methods.R
\name{elt}
\alias{elt}
\alias{elt,EL-method}
\alias{elt,QGLM-method}
\alias{elt,SD-method}
\alias{elt,missing-method}
\title{Empirical likelihood test}
\usage{
\S4method{elt}{EL}(
  object,
  rhs = NULL,
  lhs = NULL,
  alpha = 0.05,
  calibrate = "chisq",
  control = el_control()
)
}
\arguments{
\item{object}{An object that inherits from \linkS4class{EL}.}

\item{rhs}{A numeric vector or a column matrix for the right-hand side of
hypothesis, with as many entries as the rows in `lhs`. Defaults to `NULL`.
See ‘Details’.}

\item{lhs}{A numeric matrix or a vector (treated as a row matrix) for the
left-hand side of a hypothesis. Each row gives a linear combination of the
parameters in `object`. The number of columns must be equal to the number
of parameters. Or a character vector with a symbolic description of the
hypothesis is allowed. Defaults to `NULL`. See ‘Details’.}

\item{alpha}{A single numeric for the significance level. Defaults to `0.05`.}

\item{calibrate}{A single character for the calibration method. It is
case-insensitive and must be one of `"chisq"`, `"boot"`, or `"f"`.
Defaults to `"chisq"`. See ‘Details’.}

\item{control}{An object of class \linkS4class{ControlEL} constructed by
[el_control()].}
}
\value{
An object of class of \linkS4class{ELT}. If `lhs` is non-`NULL`, the
  `optim` slot corresponds to that of \linkS4class{CEL}. Otherwise, it
  corresponds to that of \linkS4class{EL}.
}
\description{
Tests a linear hypothesis.
}
\details{
[elt()] performs the constrained minimization of \eqn{l(\theta)}
  described in \linkS4class{CEL}. `rhs` and `lhs` cannot be both `NULL`. For
  non-`NULL` `lhs`, it is required that `lhs` have full row rank
  \eqn{q \leq p} and \eqn{p} be equal to the number of parameters in the
  `object`.

  Depending on the specification of `rhs` and `lhs`, we have the following
  three cases:
  1. If both `rhs` and `lhs` are non-`NULL`, the constrained minimization
  is performed with the right-hand side \eqn{r} and the left-hand side
  \eqn{L} as
  \deqn{\inf_{\theta: L\theta = r} l(\theta).}
  1. If `rhs` is `NULL`, \eqn{r} is set to the zero vector as
  \eqn{\inf_{\theta: L\theta = 0} l(\theta)}.
  1. If `lhs` is `NULL`, \eqn{L} is set to the identity matrix and the
  problem reduces to evaluating at \eqn{r} as \eqn{l(r)}.

  `calibrate` specifies the calibration method used. Three methods are
  available: `"chisq"` (chi-square calibration), `"boot"` (bootstrap
  calibration), and `"f"` (\eqn{F} calibration). `"boot"` is applicable only
  when `lhs` is `NULL`. The `nthreads`, `seed`, and `B` slots in `control`
  apply to the bootstrap procedure. `"f"` is applicable only to the mean
  parameter when `lhs` is `NULL`.
}
\examples{
## F calibration for the mean
data("precip")
fit <- el_mean(precip, 32)
elt(fit, rhs = 32, calibrate = "f")

## Test of no treatment effect
data("clothianidin")
contrast <- matrix(c(
  1, -1, 0, 0,
  0, 1, -1, 0,
  0, 0, 1, -1
), byrow = TRUE, nrow = 3)
fit2 <- el_lm(clo ~ -1 + trt, clothianidin)
elt(fit2, lhs = contrast)

## A symbolic description of the same hypothesis
elt(fit2, lhs = c(
  "trtNaked - trtFungicide",
  "trtFungicide - trtLow",
  "trtLow - trtHigh"
))
}
\references{
Adimari G, Guolo A (2010).
  “A Note on the Asymptotic Behaviour of Empirical Likelihood Statistics.”
  \emph{Statistical Methods & Applications}, 19(4), 463--476.
  \doi{10.1007/s10260-010-0137-9}.

Qin J, Lawless J (1995).
  “Estimating Equations, Empirical Likelihood and Constraints on Parameters.”
  \emph{Canadian Journal of Statistics}, 23(2), 145--159.
  \doi{10.2307/3315441}.
}
\seealso{
\linkS4class{ELT}, [elmt()], [el_control()]
}
