% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{set}
\alias{set}
\alias{\%intersect\%}
\alias{\%intersect\%.mdate}
\alias{\%union\%}
\alias{\%union\%.mdate}
\title{Set operations for messy dates}
\usage{
e1 \%intersect\% e2

\method{\%intersect\%}{mdate}(e1, e2)

e1 \%union\% e2

\method{\%union\%}{mdate}(e1, e2)
}
\arguments{
\item{e1, e2}{Messy date or other class objects}
}
\value{
A vector of the same mode for \code{intersect},
or a common mode for union.
}
\description{
Performs intersection (\code{md_intersect()}) and union (\code{md_union()}) on,
inter alia, messy date class objects.
For a more typical 'join' that retains all elements, even if duplicated,
please use \code{md_multiset}.
}
\section{Functions}{
\itemize{
\item \code{ \%intersect\% }: Find intersection of sets of messy dates

\item \code{ \%union\% }: Find intersection of sets of messy dates

}}
\examples{
as_messydate("2012-01-01..2012-01-20") \%intersect\% as_messydate("2012-01")
as_messydate("2012-01-01..2012-01-20") \%union\% as_messydate("2012-01")
}
