% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaveFlux.R
\name{EPflux}
\alias{EPflux}
\title{Computes Eliassen-Palm fluxes.}
\usage{
EPflux(lon, lat, lev, t, u, v)
}
\arguments{
\item{lon}{longitudes in degrees.}

\item{lat}{latitudes in degrees.}

\item{lev}{pressure levels.}

\item{t}{temperature in Kelvin.}

\item{u}{zonal wind in m/s.}

\item{v}{meridional wind in m/s.}
}
\value{
A data.table with columns \code{Flon}, \code{Flat} and \code{Flev} giving the zonal, meridional
and vertical components of the EP Fluxes at each longitude, latitude and level.
}
\description{
Computes Eliassen-Palm fluxes.
}
\references{
Plumb, R. A. (1985). On the Three-Dimensional Propagation of Stationary Waves. Journal of the Atmospheric Sciences, 42(3), 217–229. \url{https://doi.org/10.1175/1520-0469(1985)042<0217:OTTDPO>2.0.CO;2}
Cohen, J., Barlow, M., Kushner, P. J., & Saito, K. (2007). Stratosphere–Troposphere Coupling and Links with Eurasian Land Surface Variability. Journal of Climate, 20(21), 5335–5343. \url{https://doi.org/10.1175/2007JCLI1725.1}
}
