% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metarate.R
\name{metarate}
\alias{metarate}
\title{Meta-analysis of single incidence rates}
\usage{
metarate(
  event,
  time,
  studlab,
  data = NULL,
  subset = NULL,
  exclude = NULL,
  cluster = NULL,
  n = NULL,
  method = "Inverse",
  sm = gs("smrate"),
  incr = gs("incr"),
  method.incr = gs("method.incr"),
  method.ci = gs("method.ci.rate"),
  level = gs("level"),
  level.ma = gs("level.ma"),
  common = gs("common"),
  random = gs("random") | !is.null(tau.preset),
  overall = common | random,
  overall.hetstat = common | random,
  hakn = gs("hakn"),
  adhoc.hakn = gs("adhoc.hakn"),
  method.tau,
  method.tau.ci = gs("method.tau.ci"),
  tau.preset = NULL,
  TE.tau = NULL,
  tau.common = gs("tau.common"),
  prediction = gs("prediction"),
  level.predict = gs("level.predict"),
  null.effect = NA,
  method.bias = gs("method.bias"),
  backtransf = gs("backtransf"),
  irscale = 1,
  irunit = "person-years",
  text.common = gs("text.common"),
  text.random = gs("text.random"),
  text.predict = gs("text.predict"),
  text.w.common = gs("text.w.common"),
  text.w.random = gs("text.w.random"),
  title = gs("title"),
  complab = gs("complab"),
  outclab = "",
  subgroup,
  subgroup.name = NULL,
  print.subgroup.name = gs("print.subgroup.name"),
  sep.subgroup = gs("sep.subgroup"),
  test.subgroup = gs("test.subgroup"),
  prediction.subgroup = gs("prediction.subgroup"),
  byvar,
  keepdata = gs("keepdata"),
  warn = gs("warn"),
  warn.deprecated = gs("warn.deprecated"),
  control = NULL,
  ...
)
}
\arguments{
\item{event}{Number of events.}

\item{time}{Person time at risk.}

\item{studlab}{An optional vector with study labels.}

\item{data}{An optional data frame containing the study
information, i.e., event and time.}

\item{subset}{An optional vector specifying a subset of studies to
be used.}

\item{exclude}{An optional vector specifying studies to exclude
from meta-analysis, however, to include in printouts and forest
plots.}

\item{cluster}{An optional vector specifying which estimates come
from the same cluster resulting in the use of a three-level
meta-analysis model.}

\item{n}{Number of observations.}

\item{method}{A character string indicating which method is to be
used for pooling of studies. One of \code{"Inverse"} and
\code{"GLMM"}, can be abbreviated.}

\item{sm}{A character string indicating which summary measure
(\code{"IR"}, \code{"IRLN"}, \code{"IRS"}, or \code{"IRFT"}) is
to be used for pooling of studies, see Details.}

\item{incr}{A numeric which is added to the event number of studies
with zero events, i.e., studies with an incidence rate of 0.}

\item{method.incr}{A character string indicating which continuity
correction method should be used (\code{"only0"},
\code{"if0all"}, or \code{"all"}), see Details.}

\item{method.ci}{A character string indicating whether to use
approximate normal ("NAsm") or exact Poisson ("Poisson")
confidence limits.}

\item{level}{The level used to calculate confidence intervals for
individual studies.}

\item{level.ma}{The level used to calculate confidence intervals
for meta-analysis estimates.}

\item{common}{A logical indicating whether a common effect
meta-analysis should be conducted.}

\item{random}{A logical indicating whether a random effects
meta-analysis should be conducted.}

\item{overall}{A logical indicating whether overall summaries
should be reported. This argument is useful in a meta-analysis
with subgroups if overall results should not be reported.}

\item{overall.hetstat}{A logical value indicating whether to print
heterogeneity measures for overall treatment comparisons. This
argument is useful in a meta-analysis with subgroups if
heterogeneity statistics should only be printed on subgroup
level.}

\item{hakn}{A logical indicating whether the method by Hartung and
Knapp should be used to adjust test statistics and confidence
intervals.}

\item{adhoc.hakn}{A character string indicating whether an \emph{ad
hoc} variance correction should be applied in the case of an
arbitrarily small Hartung-Knapp variance estimate, see Details.}

\item{method.tau}{A character string indicating which method is
used to estimate the between-study variance \eqn{\tau^2} and its
square root \eqn{\tau}. Either \code{"DL"}, \code{"PM"},
\code{"REML"}, \code{"ML"}, \code{"HS"}, \code{"SJ"},
\code{"HE"}, or \code{"EB"}, can be abbreviated.}

\item{method.tau.ci}{A character string indicating which method is
used to estimate the confidence interval of \eqn{\tau^2} and
\eqn{\tau}. Either \code{"QP"}, \code{"BJ"}, \code{"J"},
\code{"PL"}, or \code{""}, can be abbreviated.}

\item{tau.preset}{Prespecified value for the square root of the
between-study variance \eqn{\tau^2}.}

\item{TE.tau}{Overall treatment effect used to estimate the
between-study variance tau-squared.}

\item{tau.common}{A logical indicating whether tau-squared should
be the same across subgroups.}

\item{prediction}{A logical indicating whether a prediction
interval should be printed.}

\item{level.predict}{The level used to calculate prediction
interval for a new study.}

\item{null.effect}{A numeric value specifying the effect under the
null hypothesis.}

\item{method.bias}{A character string indicating which test is to
be used. Either \code{"Begg"}, \code{"Egger"}, or
\code{"Thompson"}, can be abbreviated. See function
\code{\link{metabias}}.}

\item{backtransf}{A logical indicating whether results for
transformed rates (argument \code{sm != "IR"}) should be back
transformed in printouts and plots. If TRUE (default), results
will be presented as incidence rates; otherwise transformed rates
will be shown.}

\item{irscale}{A numeric defining a scaling factor for printing of
rates.}

\item{irunit}{A character string specifying the time unit used to
calculate rates, e.g. person-years.}

\item{text.common}{A character string used in printouts and forest
plot to label the pooled common effect estimate.}

\item{text.random}{A character string used in printouts and forest
plot to label the pooled random effects estimate.}

\item{text.predict}{A character string used in printouts and forest
plot to label the prediction interval.}

\item{text.w.common}{A character string used to label weights of
common effect model.}

\item{text.w.random}{A character string used to label weights of
random effects model.}

\item{title}{Title of meta-analysis / systematic review.}

\item{complab}{Comparison label.}

\item{outclab}{Outcome label.}

\item{subgroup}{An optional vector to conduct a meta-analysis with
subgroups.}

\item{subgroup.name}{A character string with a name for the
subgroup variable.}

\item{print.subgroup.name}{A logical indicating whether the name of
the subgroup variable should be printed in front of the group
labels.}

\item{sep.subgroup}{A character string defining the separator
between name of subgroup variable and subgroup label.}

\item{test.subgroup}{A logical value indicating whether to print
results of test for subgroup differences.}

\item{prediction.subgroup}{A logical indicating whether prediction
intervals should be printed for subgroups.}

\item{byvar}{Deprecated argument (replaced by 'subgroup').}

\item{keepdata}{A logical indicating whether original data (set)
should be kept in meta object.}

\item{warn}{A logical indicating whether the addition of
\code{incr} to studies with zero events should result in a
warning.}

\item{warn.deprecated}{A logical indicating whether warnings should
be printed if deprecated arguments are used.}

\item{control}{An optional list to control the iterative process to
estimate the between-study variance \eqn{\tau^2}. This argument
is passed on to \code{\link[metafor]{rma.uni}} or
\code{\link[metafor]{rma.glmm}}, respectively.}

\item{\dots}{Additional arguments passed on to
\code{\link[metafor]{rma.glmm}} function and to catch deprecated
arguments.}
}
\value{
An object of class \code{c("metarate", "meta")} with corresponding
\code{print}, \code{summary}, and \code{forest} functions. The
object is a list containing the following components:
\item{event, n, studlab, exclude, cluster,}{As defined above.}
\item{sm, incr, method.incr, method.ci,}{As defined above.}
\item{level, level.ma,}{As defined above.}
\item{common, random,}{As defined above.}
\item{overall, overall.hetstat,}{As defined above.}
\item{hakn, adhoc.hakn, method.tau, method.tau.ci,}{As defined above.}
\item{tau.preset, TE.tau, null.hypothesis,}{As defined above.}
\item{method.bias, tau.common, title, complab, outclab,}{As defined
  above.}
\item{subgroup, subgroup.name, print.subgroup.name, sep.subgroup, warn}{As defined
  above.}
\item{TE, seTE}{Estimated (un)transformed incidence rate and its
  standard error for individual studies.}
\item{lower, upper}{Lower and upper confidence interval limits for
  individual studies.}
\item{zval, pval}{z-value and p-value for test of treatment effect
  for individual studies.}
\item{w.common, w.random}{Weight of individual studies (in common
  effect and random effects model).}
\item{TE.common, seTE.common}{Estimated overall (un)transformed
  incidence rate and standard error (common effect model).}
\item{lower.common, upper.common}{Lower and upper confidence interval
  limits (common effect model).}
\item{statistic.common, pval.common}{z-value and p-value for test of
  overall effect (common effect model).}
\item{TE.random, seTE.random}{Estimated overall (un)transformed
  incidence rate and standard error (random effects model).}
\item{lower.random, upper.random}{Lower and upper confidence
  interval limits (random effects model).}
\item{statistic.random, pval.random}{z-value or t-value and
  corresponding p-value for test of overall effect (random effects
  model).}
\item{prediction, level.predict}{As defined above.}
\item{seTE.predict}{Standard error utilised for prediction
  interval.}
\item{lower.predict, upper.predict}{Lower and upper limits of
  prediction interval.}
\item{k}{Number of estimates combined in meta-analysis.}
\item{k.study}{Number of studies combined in meta-analysis.}
\item{k.all}{Number of all studies.}
\item{k.TE}{Number of studies with estimable effects.}
\item{Q}{Heterogeneity statistic Q.}
\item{df.Q}{Degrees of freedom for heterogeneity statistic.}
\item{pval.Q}{P-value of heterogeneity test.}
\item{Q.LRT}{Heterogeneity statistic for likelihood-ratio test
  (only if \code{method = "GLMM"}).}
\item{df.Q.LRT}{Degrees of freedom for likelihood-ratio test}
\item{pval.Q.LRT}{P-value of likelihood-ratio test.}
\item{tau2}{Between-study variance \eqn{\tau^2}.}
\item{se.tau2}{Standard error of \eqn{\tau^2}.}
\item{lower.tau2, upper.tau2}{Lower and upper limit of confidence
  interval for \eqn{\tau^2}.}
\item{tau}{Square-root of between-study variance \eqn{\tau}.}
\item{lower.tau, upper.tau}{Lower and upper limit of confidence
  interval for \eqn{\tau}.}
\item{H}{Heterogeneity statistic H.}
\item{lower.H, upper.H}{Lower and upper confidence limit for
 heterogeneity statistic H.}
\item{I2}{Heterogeneity statistic I\eqn{^2}.}
\item{lower.I2, upper.I2}{Lower and upper confidence limit for
  heterogeneity statistic I\eqn{^2}.}
\item{Rb}{Heterogeneity statistic R\eqn{_b}.}
\item{lower.Rb, upper.Rb}{Lower and upper confidence limit for
  heterogeneity statistic R\eqn{_b}.}
\item{method}{A character string indicating method used for
  pooling: \code{"Inverse"}}
\item{df.hakn}{Degrees of freedom for test of treatment effect for
  Hartung-Knapp method (only if \code{hakn = TRUE}).}
\item{bylevs}{Levels of grouping variable - if \code{subgroup} is not
  missing.}
\item{TE.common.w, seTE.common.w}{Estimated treatment effect and
  standard error in subgroups (common effect model) - if
  \code{subgroup} is not missing.}
\item{lower.common.w, upper.common.w}{Lower and upper confidence
  interval limits in subgroups (common effect model) - if
  \code{subgroup} is not missing.}
\item{statistic.common.w, pval.common.w}{z-value and p-value for test
  of treatment effect in subgroups (common effect model) - if
  \code{subgroup} is not missing.}
\item{TE.random.w, seTE.random.w}{Estimated treatment effect and
  standard error in subgroups (random effects model) - if
  \code{subgroup} is not missing.}
\item{lower.random.w, upper.random.w}{Lower and upper confidence
  interval limits in subgroups (random effects model) - if
  \code{subgroup} is not missing.}
\item{statistic.random.w, pval.random.w}{z-value or t-value and
  corresponding p-value for test of treatment effect in subgroups
  (random effects model) - if \code{subgroup} is not missing.}
\item{w.common.w, w.random.w}{Weight of subgroups (in common effect
  and random effects model) - if \code{subgroup} is not missing.}
\item{df.hakn.w}{Degrees of freedom for test of treatment effect
  for Hartung-Knapp method in subgroups - if \code{subgroup} is not
  missing and \code{hakn = TRUE}.}
\item{n.harmonic.mean.w}{Harmonic mean of number of observations in
  subgroups (for back transformation of Freeman-Tukey Double
  arcsine transformation) - if \code{subgroup} is not missing.}
\item{event.w}{Number of events in subgroups - if \code{subgroup} is
  not missing.}
\item{n.w}{Number of observations in subgroups - if \code{subgroup} is
  not missing.}
\item{k.w}{Number of studies combined within subgroups - if
  \code{subgroup} is not missing.}
\item{k.all.w}{Number of all studies in subgroups - if \code{subgroup}
  is not missing.}
\item{Q.w.common}{Overall within subgroups heterogeneity statistic Q
  (based on common effect model) - if \code{subgroup} is not missing.}
\item{Q.w.random}{Overall within subgroups heterogeneity statistic
  Q (based on random effects model) - if \code{subgroup} is not
  missing (only calculated if argument \code{tau.common} is TRUE).}
\item{df.Q.w}{Degrees of freedom for test of overall within
  subgroups heterogeneity - if \code{subgroup} is not missing.}
\item{pval.Q.w.common}{P-value of within subgroups heterogeneity
  statistic Q (based on common effect model) - if \code{subgroup} is
  not missing.}
\item{pval.Q.w.random}{P-value of within subgroups heterogeneity
  statistic Q (based on random effects model) - if \code{subgroup} is
  not missing.}
\item{Q.b.common}{Overall between subgroups heterogeneity statistic
  Q (based on common effect model) - if \code{subgroup} is not
  missing.}
\item{Q.b.random}{Overall between subgroups heterogeneity statistic
  Q (based on random effects model) - if \code{subgroup} is not
  missing.}
\item{df.Q.b}{Degrees of freedom for test of overall between
  subgroups heterogeneity - if \code{subgroup} is not missing.}
\item{pval.Q.b.common}{P-value of between subgroups heterogeneity
  statistic Q (based on common effect model) - if \code{subgroup} is
  not missing.}
\item{pval.Q.b.random}{P-value of between subgroups heterogeneity
  statistic Q (based on random effects model) - if \code{subgroup} is
  not missing.}
\item{tau.w}{Square-root of between-study variance within subgroups
  - if \code{subgroup} is not missing.}
\item{H.w}{Heterogeneity statistic H within subgroups - if
  \code{subgroup} is not missing.}
\item{lower.H.w, upper.H.w}{Lower and upper confidence limit for
  heterogeneity statistic H within subgroups - if \code{subgroup} is
  not missing.}
\item{I2.w}{Heterogeneity statistic I\eqn{^2} within subgroups - if
  \code{subgroup} is not missing.}
\item{lower.I2.w, upper.I2.w}{Lower and upper confidence limit for
  heterogeneity statistic I\eqn{^2} within subgroups - if \code{subgroup} is
  not missing.}
\item{incr.event}{Increment added to number of events.}
\item{keepdata}{As defined above.}
\item{data}{Original data (set) used in function call (if
  \code{keepdata = TRUE}).}
\item{subset}{Information on subset of original data used in
  meta-analysis (if \code{keepdata = TRUE}).}
\item{.glmm.common}{GLMM object generated by call of
  \code{\link[metafor]{rma.glmm}} function (common effect model).}
\item{.glmm.random}{GLMM object generated by call of
  \code{\link[metafor]{rma.glmm}} function (random effects model).}
\item{call}{Function call.}
\item{version}{Version of R package \bold{meta} used to create
  object.}
\item{version.metafor}{Version of R package \bold{metafor} used for
  GLMMs.}
}
\description{
Calculation of an overall incidence rate from studies reporting a
single incidence rate. Inverse variance method and generalised
linear mixed model (GLMM) are available for pooling. For GLMMs, the
\code{\link[metafor]{rma.glmm}} function from R package
\bold{metafor} (Viechtbauer 2010) is called internally.
}
\details{
This function provides methods for common effect and random effects
meta-analysis of single incidence rates to calculate an overall
rate. Note, you should use R function \code{\link{metainc}} to
compare incidence rates of pairwise comparisons instead of using
\code{metarate} for each treatment arm separately which will break
randomisation in randomised controlled trials.

The following transformations of incidence rates are implemented to
calculate an overall rate:

\itemize{
\item Log transformation (\code{sm = "IRLN"}, default)
\item Square root transformation (\code{sm = "IRS"})
\item Freeman-Tukey Double arcsine transformation (\code{sm =
  "IRFT"})
\item No transformation (\code{sm = "IR"})
}

By default (argument \code{method = "Inverse"}), the inverse
variance method (Borenstein et al., 2010) is used for pooling by
calling \code{\link{metagen}} internally. A random intercept
Poisson regression model (Stijnen et al., 2010) can be utilised
instead with argument \code{method = "GLMM"} which calls the
\code{\link[metafor]{rma.glmm}} function from R package
\bold{metafor}.

Default settings are utilised for several arguments (assignments
using \code{\link{gs}} function). These defaults can be changed for
the current R session using the \code{\link{settings.meta}}
function.

Furthermore, R function \code{\link{update.meta}} can be used to
rerun a meta-analysis with different settings.

\subsection{Continuity correction}{

Three approaches are available to apply a continuity correction:
\itemize{
\item Only studies with a zero cell count (\code{method.incr =
  "only0"})
\item All studies if at least one study has a zero cell count
  (\code{method.incr = "if0all"})
\item All studies irrespective of zero cell counts
  (\code{method.incr = "all"})
}

If the summary measure (argument \code{sm}) is equal to "IR" or
"IRLN", the continuity correction is applied if a study has zero
events, i.e., an incidence rate of 0.

By default, 0.5 is used as continuity correction (argument
\code{incr}). This continuity correction is used both to calculate
individual study results with confidence limits and to conduct
meta-analysis based on the inverse variance method.

For the Freeman-Tukey (Freeman & Tukey, 1950) and square root
transformation as well as GLMMs no continuity correction is used.
}

\subsection{Estimation of between-study variance}{

The following methods to estimate the between-study variance
\eqn{\tau^2} are available for the inverse variance method:
\itemize{
\item DerSimonian-Laird estimator (\code{method.tau = "DL"})
\item Paule-Mandel estimator (\code{method.tau = "PM"})
\item Restricted maximum-likelihood estimator (\code{method.tau =
  "REML"})
\item Maximum-likelihood estimator (\code{method.tau = "ML"})
\item Hunter-Schmidt estimator (\code{method.tau = "HS"})
\item Sidik-Jonkman estimator (\code{method.tau = "SJ"})
\item Hedges estimator (\code{method.tau = "HE"})
\item Empirical Bayes estimator (\code{method.tau = "EB"})
}
See \code{\link{metagen}} for more information on these
estimators. Note, the maximum-likelihood method is utilized for
GLMMs.
}

\subsection{Confidence interval for the between-study variance}{

The following methods to calculate a confidence interval for
\eqn{\tau^2} and \eqn{\tau} are available.
\tabular{ll}{
\bold{Argument}\tab \bold{Method} \cr
\code{method.tau.ci = "J"}\tab Method by Jackson (2013) \cr
\code{method.tau.ci = "BJ"}\tab Method by Biggerstaff and Jackson (2008) \cr
\code{method.tau.ci = "QP"}\tab Q-Profile method (Viechtbauer, 2007) \cr
\code{method.tau.ci = "PL"}\tab Profile-Likelihood method for
  three-level meta-analysis \cr
 \tab (Van den Noortgate et al., 2013) \cr
\code{method.tau.ci = ""}\tab No confidence interval
}

See \code{\link{metagen}} for more information on these methods.

For GLMMs, no confidence intervals for \eqn{\tau^2} and \eqn{\tau}
are calculated.
}

\subsection{Hartung-Knapp method}{

Hartung and Knapp (2001a,b) proposed an alternative method for
random effects meta-analysis based on a refined variance estimator
for the treatment estimate. Simulation studies (Hartung and Knapp,
2001a,b; IntHout et al., 2014; Langan et al., 2019) show improved
coverage probabilities compared to the classic random effects
method.

In rare settings with very homogeneous treatment estimates, the
Hartung-Knapp variance estimate can be arbitrarily small resulting
in a very narrow confidence interval (Knapp and Hartung, 2003;
Wiksten et al., 2016). In such cases, an \emph{ad hoc} variance
correction has been proposed by utilising the variance estimate
from the classic random effects model with the HK method (Knapp and
Hartung, 2003; IQWiQ, 2020). An alternative approach is to use the
wider confidence interval of classic common or random effects
meta-analysis and the HK method (Wiksten et al., 2016; Jackson et
al., 2017).

Argument \code{adhoc.hakn} can be used to choose the \emph{ad hoc}
method:
\tabular{ll}{
\bold{Argument}\tab \bold{\emph{Ad hoc} method} \cr
\code{adhoc.hakn = ""}\tab not used \cr
\code{adhoc.hakn = "se"}\tab use variance correction if HK standard
 error is smaller \cr
 \tab than standard error from classic random effects
 \cr
 \tab meta-analysis (Knapp and Hartung, 2003) \cr
\code{adhoc.hakn = "iqwig6"}\tab use variance correction if HK
 confidence interval \cr
 \tab is narrower than CI from classic random effects model \cr
 \tab with DerSimonian-Laird estimator (IQWiG, 2020) \cr
\code{adhoc.hakn = "ci"}\tab use wider confidence interval of
 classic random effects \cr
 \tab and HK meta-analysis \cr
 \tab (Hybrid method 2 in Jackson et al., 2017)
}

For GLMMs, a method similar to Knapp and Hartung (2003) is
implemented, see description of argument \code{tdist} in
\code{\link[metafor]{rma.glmm}}, and the \emph{ad hoc} variance
correction is not available.
}

\subsection{Prediction interval}{

A prediction interval for the proportion in a new study (Higgins et
al., 2009) is calculated if arguments \code{prediction} and
\code{random} are \code{TRUE}. Note, the definition of
prediction intervals varies in the literature. This function
implements equation (12) of Higgins et al., (2009) which proposed a
\emph{t} distribution with \emph{K-2} degrees of freedom where
\emph{K} corresponds to the number of studies in the meta-analysis.
}

\subsection{Subgroup analysis}{

Argument \code{subgroup} can be used to conduct subgroup analysis for
a categorical covariate. The \code{\link{metareg}} function can be
used instead for more than one categorical covariate or continuous
covariates.
}

\subsection{Specify the null hypothesis of test for an overall effect}{

Argument \code{null.effect} can be used to specify the rate used
under the null hypothesis in a test for an overall effect.

By default (\code{null.effect = NA}), no hypothesis test is
conducted as it is unclear which value is a sensible choice for the
data at hand.  An overall rate of 2, for example, could be tested
by setting argument \code{null.effect = 2}.

Note, all tests for an overall effect are two-sided with the
alternative hypothesis that the effect is unequal to
\code{null.effect}.
}

\subsection{Exclusion of studies from meta-analysis}{

Arguments \code{subset} and \code{exclude} can be used to exclude
studies from the meta-analysis. Studies are removed completely from
the meta-analysis using argument \code{subset}, while excluded
studies are shown in printouts and forest plots using argument
\code{exclude} (see Examples in \code{\link{metagen}}).
Meta-analysis results are the same for both arguments.
}

\subsection{Presentation of meta-analysis results}{

Internally, both common effect and random effects models are
calculated regardless of values choosen for arguments
\code{common} and \code{random}. Accordingly, the estimate
for the random effects model can be extracted from component
\code{TE.random} of an object of class \code{"meta"} even if
argument \code{random = FALSE}. However, all functions in R
package \bold{meta} will adequately consider the values for
\code{common} and \code{random}. E.g. function
\code{\link{print.meta}} will not print results for the random
effects model if \code{random = FALSE}.

Argument \code{irscale} can be used to rescale rates, e.g.
\code{irscale = 1000} means that rates are expressed as events per
1000 time units, e.g. person-years. This is useful in situations
with (very) low rates. Argument \code{irunit} can be used to
specify the time unit used in individual studies (default:
"person-years"). This information is printed in summaries and
forest plots if argument \code{irscale} is not equal to 1.
}
}
\examples{
# Apply various meta-analysis methods to estimate incidence rates
#
m1 <- metarate(4:1, c(10, 20, 30, 40))
m2 <- update(m1, sm = "IR")
m3 <- update(m1, sm = "IRS")
m4 <- update(m1, sm = "IRFT")
#
m1
m2
m3
m4
#
forest(m1)
forest(m1, irscale = 100)
forest(m1, irscale = 100, irunit = "person-days")
forest(m1, backtransf = FALSE)
\dontrun{
forest(m2)
forest(m3)
forest(m4)
}

m5 <- metarate(40:37, c(100, 200, 300, 400), sm = "IRFT")
m5

}
\references{
Borenstein M, Hedges LV, Higgins JP, Rothstein HR (2010):
A basic introduction to fixed-effect and random-effects models for
meta-analysis.
\emph{Research Synthesis Methods},
\bold{1}, 97--111

Freeman MF & Tukey JW (1950):
Transformations related to the angular and the square root.
\emph{Annals of Mathematical Statistics},
\bold{21}, 607--11

Higgins JPT, Thompson SG, Spiegelhalter DJ (2009):
A re-evaluation of random-effects meta-analysis.
\emph{Journal of the Royal Statistical Society: Series A},
\bold{172}, 137--59

Hartung J, Knapp G (2001a):
On tests of the overall treatment effect in meta-analysis with
normally distributed responses.
\emph{Statistics in Medicine},
\bold{20}, 1771--82

Hartung J, Knapp G (2001b):
A refined method for the meta-analysis of controlled clinical
trials with binary outcome.
\emph{Statistics in Medicine},
\bold{20}, 3875--89

IntHout J, Ioannidis JPA, Borm GF (2014):
The Hartung-Knapp-Sidik-Jonkman method for random effects
meta-analysis is straightforward and considerably outperforms the
standard DerSimonian-Laird method.
\emph{BMC Medical Research Methodology},
\bold{14}, 25

IQWiG (2020):
General Methods: Version 6.0.
\url{https://www.iqwig.de/en/about-us/methods/methods-paper/}

Jackson D, Law M, Rücker G, Schwarzer G (2017): 
The Hartung-Knapp modification for random-effects meta-analysis: A
useful refinement but are there any residual concerns?
\emph{Statistics in Medicine},
\bold{36}, 3923--34

Langan D, Higgins JPT, Jackson D, Bowden J, Veroniki AA,
Kontopantelis E, et al. (2019):
A comparison of heterogeneity variance estimators in simulated
random-effects meta-analyses.
\emph{Research Synthesis Methods},
\bold{10}, 83--98

Stijnen T, Hamza TH, Ozdemir P (2010):
Random effects meta-analysis of event outcome in the framework of
the generalized linear mixed model with applications in sparse
data.
\emph{Statistics in Medicine},
\bold{29}, 3046--67

Van den Noortgate W, López-López JA, Marín-Martínez F, Sánchez-Meca J (2013):
Three-level meta-analysis of dependent effect sizes.
\emph{Behavior Research Methods},
\bold{45}, 576--94

Viechtbauer W (2010):
Conducting Meta-Analyses in R with the Metafor Package.
\emph{Journal of Statistical Software},
\bold{36}, 1--48

Wiksten A, Rücker G, Schwarzer G (2016):
Hartung-Knapp method is not always conservative compared with
fixed-effect meta-analysis.
\emph{Statistics in Medicine},
\bold{35}, 2503--15
}
\seealso{
\code{\link{update.meta}}, \code{\link{metacont}},
  \code{\link{metagen}}, \code{\link{print.meta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
