% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_es.R
\name{transform_es}
\alias{transform_es}
\title{Transformation of Effect Sizes}
\usage{
transform_es(y, SE, from, to)
}
\arguments{
\item{y}{estimate of the effect size (can be vectorized).}

\item{SE}{optional: standard error of the effect-size estimate. Must have the
same length as \code{y}.}

\item{from}{type of effect-size measure provided by the argument \code{y}.
Supported effect sizes are
Cohen's d (\code{"d"}),
Fisher's z-transformed correlation (\code{"z"}),
Pearson's correlation (\code{"r"}),
or the log odds ratio (\code{"logOR"}).}

\item{to}{which type of effect size should be returned (see \code{from}).}
}
\value{
If \code{SE} is missing, a vector of transformed effect sizes. Otherwise,
a matrix with two columns including effect sizes and standard errors.
}
\description{
Converts between different measures of effect size (i.e., Cohen's d, log odds
ratio, Pearson correlation r, and Fisher's z).
}
\details{
The following chain of transformations is adopted from Borenstein et al. (2009):
\code{logOR <--> d <--> r <--> z}.
The conversion from \code{"d"} to \code{"r"} assumes equal sample sizes per condition (n1=n2).

Note that in in a Bayesian meta-analysis, the prior distributions need to be adapted to the type of effect size. The function \code{\link{meta_default}} provides modified default prior distributions for different effect size measures which are approximately transformation-invariant (but results may still differ depending on which type of effect size is used for analysis).
}
\examples{
# transform a single value of Cohen's
transform_es(y = 0.50, SE = 0.20, from = "d", to = "logOR")

# towels data set:
transform_es(y = towels$logOR, SE = towels$SE, from = "logOR", to = "d")

}
\references{
Borenstein, M., Hedges, L. V., Higgins, J. P. T., & Rothstein, H. R. (2009). Converting among effect sizes. In Introduction to Meta-Analysis (pp. 45–49). John Wiley & Sons, Ltd. \doi{10.1002/9780470743386.ch7}
}
\seealso{
\code{\link{meta_default}}
}
