% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_2x2.R
\name{es_from_2x2}
\alias{es_from_2x2}
\title{Convert a 2x2 table into several effect size measures}
\usage{
es_from_2x2(
  n_cases_exp,
  n_cases_nexp,
  n_controls_exp,
  n_controls_nexp,
  table_2x2_to_cor = "tetrachoric",
  reverse_2x2
)
}
\arguments{
\item{n_cases_exp}{number of cases/events in the exposed group}

\item{n_cases_nexp}{number of cases/events in the non exposed group}

\item{n_controls_exp}{number of controls/no-event in the exposed group}

\item{n_controls_nexp}{number of controls/no-event in the non exposed group}

\item{table_2x2_to_cor}{formula used to obtain a correlation coefficient from the contingency table (see details).}

\item{reverse_2x2}{a logical value indicating whether the direction of generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab OR + RR + NNT\cr
\tab \cr
\code{converted effect size measure} \tab D + G + R + Z \cr
\tab \cr
\code{required input data} \tab See 'Section 7. Contingency (2x2) table or proportions'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert a 2x2 table into several effect size measures
}
\details{
This function first computes (log) odds ratio (OR), (log) risk ratio (RR) and number needed to treat (NNT)
from the 2x2 table.
Cohen's d (D), Hedges' g (G) and correlation coefficients (R/Z) are then estimated from the OR.

\strong{To estimate an OR}, the formulas used (Box 6.4.a in the Cochrane Handbook) are:
\deqn{logor = log(\frac{n\_cases\_exp / n\_cases\_nexp}{n\_controls\_exp / n\_controls\_nexp})}
\deqn{logor\_se = \sqrt{\frac{1}{n\_cases\_exp} + \frac{1}{n\_cases\_nexp} + \frac{1}{n\_controls\_exp} + \frac{1}{n\_controls\_nexp}}}

\strong{To estimate an RR}, the formulas used (Box 6.4.a in the Cochrane Handbook) are:
\deqn{logrr = log(\frac{n\_cases\_exp / n\_exp}{n\_cases\_nexp / n\_nexp})}
\deqn{logrr\_se = \sqrt{\frac{1}{n\_cases\_exp} - \frac{1}{n\_exp} + \frac{1}{n\_cases\_nexp} - \frac{1}{n\_nexp}}}

\strong{To estimate a NNT}, the formulas used are (Sedwick, 2013) :
\deqn{pt = \frac{n\_cases\_exp}{n\_cases\_exp + n\_controls\_exp}}
\deqn{pc = \frac{n\_cases\_nexp}{n\_cases\_nexp + n\_controls\_nexp}}
\deqn{AAR = pc - pt}
\deqn{nnt = \frac{1}{AAR}}

\strong{To convert the 2x2 table into a SMD},
the function estimates an OR value from the 2x2 table (formula above)
that is then converted to a SMD
(see formula in \code{\link{es_from_or_se}()}).

\strong{To convert the 2x2 table into a correlation coefficient},
various formulas can be used.

\strong{A.} First, Cooper et al. (2019) - \code{table_2x2_to_cor = "cooper"} -
proposes to convert the
2x2 table into a OR (formula above), to convert this OR into a SMD
(see formula in \code{\link{es_from_or_se}()}), and to convert this
SMD into a correlation coefficient (see formula in \code{\link{es_from_cohen_d}()},
with the option \code{"smd_to_cor = 'lipsey_cooper'"}).

\strong{B.} Second, a correlation coefficient (more precisely - a phi coefficient)
can be obtained from the contingency table using the formula given in
Lipsey and Wilson (2001) - \code{table_2x2_to_cor = "lipsey"}.
The formulas used to estimate the r and z are:
\deqn{r = \frac{(n\_cases\_exp*n\_controls\_nexp - n\_controls\_exp*n\_cases\_nexp)}{\sqrt{(n\_exp) * (n\_nexp) * (n\_cases) * (n\_controls\_exp+n\_cases\_nexp)}}}
\deqn{z = atanh(r)}
\deqn{z\_se = logor\_se^2 * \frac{z^2}{\log(or)^2}}
\deqn{z\_ci\_lo = z - qnorm(.975)*z\_se}
\deqn{z\_ci\_up = z + qnorm(.975)*z\_se}
\deqn{r\_ci\_lo = tanh(z\_ci\_lo)}
\deqn{r\_ci\_up = tanh(z\_ci\_up)}
\deqn{effective\_n = \frac{1}{z\_se^2 + 3}}
\deqn{r\_se = \frac{(1 - r^2)^2}{effective\_n - 1}}

\strong{C.} Third, a tetrachoric correlation can be estimated from the 2x2 table
\itemize{
\item \code{table_2x2_to_cor = "tetrachoric"}.
Given the heavy calculations required for this effect size measure,
we relied on the implementation of the formulas of the 'metafor' package. More
information can be retrieved here
(https://wviechtb.github.io/metafor/reference/escalc.html#-b-measures-for-two-dichotomous-variables).
}
}
\examples{
es_from_2x2(n_cases_exp = 467, n_cases_nexp = 22087, n_controls_exp = 261, n_controls_nexp = 8761)
}
\references{
Cooper, H., Hedges, L.V., & Valentine, J.C. (Eds.). (2019). The handbook of research synthesis and meta-analysis. Russell Sage Foundation.

Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch VA (editors). Cochrane Handbook for Systematic Reviews of Interventions version 6.3 (updated February 2022). Available from www.training.cochrane.org/handbook.

Lipsey, M. W., & Wilson, D. B. (2001). Practical meta-analysis. Sage Publications, Inc.

Sedgwick, P. (2013). What is number needed to treat (NNT)? Bmj, 347.
}
