% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/es_from_stand_COR.R
\name{es_from_fisher_z}
\alias{es_from_fisher_z}
\title{Convert a Fisher's z (r-to-z transformation) to several effect size measures}
\usage{
es_from_fisher_z(
  fisher_z,
  n_sample,
  unit_type = "raw_scale",
  n_exp,
  n_nexp,
  cor_to_smd = "viechtbauer",
  sd_iv,
  unit_increase_iv,
  reverse_fisher_z
)
}
\arguments{
\item{fisher_z}{a Fisher's r-to-z transformed correlation coefficient}

\item{n_sample}{the total number of participants}

\item{unit_type}{the type of unit for the \code{unit_increase_iv} argument. Must be either "sd" or "value"}

\item{n_exp}{number of the experimental/exposed group}

\item{n_nexp}{number of the non-experimental/non-exposed group}

\item{cor_to_smd}{formula used to convert a \code{pearson_r} or \code{fisher_z} value into a SMD.}

\item{sd_iv}{the standard deviation of the independent variable}

\item{unit_increase_iv}{a value of the independent variable that will be used to estimate the Cohen's d (see details).}

\item{reverse_fisher_z}{a logical value indicating whether the direction of the generated effect sizes should be flipped.}
}
\value{
This function estimates and converts between several effect size measures.

\tabular{ll}{
\code{natural effect size measure} \tab R + Z\cr
\tab \cr
\code{converted effect size measure} \tab D + G + OR\cr
\tab \cr
\code{required input data} \tab See 'Section 4. Pearson's r or Fisher's z'\cr
\tab https://metaconvert.org/html/input.html\cr
\tab \cr
}
}
\description{
Convert a Fisher's z (r-to-z transformation) to several effect size measures
}
\details{
This function converts estimates the standard error of the Fisher's z and performs the z-to-r Fisher's transformation.

Last, it converts this r value into a Cohen's d and OR (see details in \code{\link{es_from_pearson_r}()}).
}
\examples{
es_from_fisher_z(
  fisher_z = .21, n_sample = 44,
)
}
\references{
Cooper, H., Hedges, L.V., & Valentine, J.C. (Eds.). (2019). The handbook of research synthesis and meta-analysis. Russell Sage Foundation.

Mathur, M. B., & VanderWeele, T. J. (2020). A Simple, Interpretable Conversion from Pearson's Correlation to Cohen's for d Continuous Exposures. Epidemiology (Cambridge, Mass.), 31(2), e16–e18. https://doi.org/10.1097/EDE.0000000000001105

Viechtbauer W (2010). “Conducting meta-analyses in R with the metafor package.” Journal of Statistical Software, 36(3), 1–48. doi:10.18637/jss.v036.i03.
}
