% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaboGSE.R
\name{pwDesc}
\alias{pwDesc}
\title{Description of gene set IDs}
\usage{
pwDesc(x, desc.data = NULL)
}
\arguments{
\item{x}{A vector of gene set IDs.}

\item{desc.data}{A named vector of descriptions of all studied gene set IDs. Default: NULL, 
AnnotationDbi is used if x is a GO term ID. KEGGREST will be called with internet connection required if x is a KEGG pathway ID.}
}
\value{
Description
}
\description{
This function returns the description of given gene set IDs, e.g. GO, KEGG.
}
\examples{
pwDesc("GO:0006696")
pwDesc("genesetX", desc.data=setNames("processX", "genesetX"))
\donttest{
pwDesc("hsa04930")
}
}
