% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{batch_norm}
\alias{batch_norm}
\title{batch normalization}
\usage{
batch_norm(
  object,
  feature_platform = "PLATFORM",
  QC_ID_pattern = "MTRX",
  test = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{object}{A Metabolite object. In the feature annotation slot `feature`, a platform column should be provided for metabolite measurement platform (eg. `PLATFORM`). The values in the `PLATFORM` column (eg. `Neg`, `Polar`, `Pos Early`, and `Pos Late`) are column names in the sample annotation `sample` to determine the batches of samples.}

\item{feature_platform}{The column name of feature platform for metabolite measurements (eg. `PLATFORM`).}

\item{QC_ID_pattern}{A character pattern to determine QC samples. Default value: "MTRX".}

\item{test}{test the function for the first 20 columns.}

\item{verbose}{print log information.}
}
\value{
A Metabolite object after normalization.
}
\description{
Normalization data by the median value of each batch
}
\seealso{
\code{\link{QCmatrix_norm}}
}
