% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.scenario.R
\name{get.scenario}
\alias{get.scenario}
\title{Classify scenario based on summary measures}
\usage{
get.scenario(min.val, q1.val, med.val, q3.val, max.val, mean.val, sd.val)
}
\arguments{
\item{min.val}{numeric value giving the sample minimum.}

\item{q1.val}{numeric value giving the sample first quartile.}

\item{med.val}{numeric value giving the sample median.}

\item{q3.val}{numeric value giving the sample third quartile.}

\item{max.val}{numeric value giving the sample maximum.}

\item{mean.val}{numeric value giving the sample mean.}

\item{sd.val}{numeric value giving the sample standard deviation.}
}
\value{
A character string of one of the following: \code{"S1"}, \code{"S2"}, \code{"S3"}, or \code{"S4"}.
}
\description{
The function indicates whether S1, S2, S3, or S4 summary measures are provided.  See documentation of \code{\link{qe}} for definitions of S1, S2, S3, and S4 summary measures. Note that the sample size is not included in this check.
}
\examples{
scenario <- get.scenario(min.val=1, med.val=5, max.val=20)
}
