% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umbrella_XLS.R
\name{umbrella.xls}
\alias{umbrella.xls}
\title{Function for conducting an umbrella review in R and automatically exporting results}
\usage{
umbrella.xls(
  input_file = NULL,
  sheet = 1,
  output_path = "",
  output_name = "",
  factors_to_analyze = "",
  evidence = NULL,
  plot_results = FALSE
)
}
\arguments{
\item{input_file}{path indicating the folder where your dataset is located.}

\item{sheet}{the number of the excel sheet where your data are located.}

\item{output_path}{path indicating the folder where you want the results to be created.}

\item{output_name}{name of the files created by the function.}

\item{factors_to_analyze}{the name(s) of factors to analyze. Can be either a character string indicating the name of the factor to analyze or a vector indicating the names of the factors to analyze.}

\item{evidence}{criteria used to stratify evidence. Must be either "Ioannidis" or "GRADE".}

\item{plot_results}{indicate whether a forest plot of the results is returned. Must be either TRUE or FALSE.}
}
\value{
The \code{umbrella.xls()} function returns several elements including
\tabular{ll}{
\code{csv} \tab a csv file containing the results of the umbrella review.\cr
\tab \cr
\code{pdf} \tab a pdf file containing the plot of the results (only if requested, i.e., the \code{plot_results}\cr
\tab argument is set as TRUE).\cr
\tab \cr
\code{html} \tab an HTML file containing the results of the umbrella review.\cr
}

See \code{\link{umbrella}()}, \code{\link{add.evidence}()}, and \code{\link{summary.umbrella}()} for more information.
}
\description{
The \code{umbrella.xls} function allows to automatically perform an umbrella review and to export results.
}
\details{
The function performs calculations required to stratify evidence in an umbrella review and automatically performs the stratification of evidence.
In other words, this function implicitly calls the \code{\link{view.errors.umbrella}()} function to check formatting, the \code{\link{umbrella}()} to run calculations, the \code{\link{add.evidence}()} function to stratify the evidence, and the \code{\link{forest}()} function to generated a visual representation of the results.
}
\examples{
if(interactive()){
### perform an umbrella review according to the GRADE criteria.
### the umbrella review is restricted to the factor Pharmacological of the df.SMD and to the
### RCTs conducted between the years 2000 and 2010.
### Note that the df.SMD should be stored under a .xls or .xlsx format
umbrella.xls(input_file = file.choose(),
             sheet = 1,
             output_path = choose.dir(),
             output_name = "Pharmacological_Ioannidis",
             factors_to_analyze = c("Pharmacological"),
             evidence = "GRADE",
             plot_results = TRUE)
}
}
