% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sesIndiv.R
\name{sesIndiv}
\alias{sesIndiv}
\title{Summary statistics of SES results}
\usage{
sesIndiv(raw.results, concat.by)
}
\arguments{
\item{raw.results}{A list of lists of lists of dataframes; the results of a call to
readIn.}

\item{concat.by}{Whether randomizations were concatenated by richness, plot or both.}
}
\value{
A data frame summarizing the total number of runs per spatial simulation, null,
metric, concat.by combination, as well as the type I and II error rates of each such
unique combination.
}
\description{
Summarizes individual iteration performance of each sim/null/metric combination across
all iterations
}
\details{
This function takes a raw list of results from multiple iterations from
multiLinker, and runs sesSingle across each one. It then summarizes the results of
those single runs as the number of sim/null/metrics that deviated beyond expectations
and the number that were within expectations. A single run from a given unique metric +
null approach is considered as throwing a type I error only if p is less
than or equal to 0.05 for the random spatial simulation. It would be possible to also
assess whether such unique combinations throw the opposite signal than expected for
habitat filtering and competitive exclusion. A unique combination iteration is
considered to throw a type II error if the p value from  either the filtering or the
exclusion simulation is greater than 0.05.
}
\examples{
#not run
#results <- readIn()
#summ <- sesIndiv(results, "both")
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2015. Phylogenetic community
structure metrics and null models: a review with new methods and software.
bioRxiv 025726.
}

