% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcBetaMetrics.R
\name{calcBetaMetrics}
\alias{calcBetaMetrics}
\title{Calculate phylogenetic community structure beta metrics}
\usage{
calcBetaMetrics(metrics.input, metrics, new_ = FALSE)
}
\arguments{
\item{metrics.input}{Prepped metrics.input object}

\item{metrics}{Optional. If not provided, defines the metrics as all of those in
defineBetaMetrics. If only a subset of those metrics is desired, then metrics should
take form of a character vector corresponding to named functions from
defineBetaMetrics. The available metrics can be determined by running
names(defineBetaMetrics()). Otherwise,
if the user would like to define a new metric on the fly, the argument metrics can take
the form of a named list of new functions (metrics). If the
latter, new_ must be set to TRUE.}

\item{new_}{Whether or not new metrics are being defined on the fly. Default is FALSE.
Set to TRUE if a new metric is being used.}
}
\value{
A data frame with the calculated metrics and the associated species richness
and total abundance of all input "communities".
}
\description{
Given a prepped metrics.input object, calculate all phylogenetic community structure
metrics of interest.
}
\details{
This function first confirms that the input is of class metrics.input and,
if so, then confirms that the metrics to be calculated are in a named list (via
checkMetrics), then lapplies all metric functions to the input metrics.input object.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1))

cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)

prepped <- prepData(tree, cdm)

results <- calcBetaMetrics(prepped)

#an example of how to define ones own metrics for use in the metricTester framework
#this "metric" simply calculates the richness of each plot in the CDM
exampleMetric <- function(metrics.input)
{
output <- mean(apply(metrics.input$picante.cdm, 1, lengthNonZeros))
output
}

calcBetaMetrics(prepped, metrics=list("example"=exampleMetric), new_=TRUE)
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}

