% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeRoadMap.R
\name{makeRoadMap}
\alias{makeRoadMap}
\title{Create a road map for use in FDis-related functions}
\usage{
makeRoadMap(ordination.results)
}
\arguments{
\item{ordination.results}{data.frame summarizing the location of the points in the
ordination over which to calculate FDis. For example, the $x object of a call to
prcomp. Formatting of this ordination.results object is currently strict. It must be a
data frame, it must not have row.names, and it must have a column called 'species'.}
}
\value{
A data.frame summarizing which points in the ordination space "belong" to
which species or plots over which to calculate FDis.
}
\description{
Based on an ordination space, convert into the road.map required by the FDis-related
functions, and by the dbFD function in the FDis package.
}
\details{
This is currently a basic utility function with very little flexibility. It
assumes you have a data.frame without row.names and a column called species. If you
would like to calculate plot-level FDis, sensu Laliberte & Legendre, you will still
need to have a column named species. See examples for more details.
This function will create the object called 'a'
used in the dbFD function of the FDis package. However, it gives all points equal
weighting, i.e., the returned object will only contain 0s and 1s.
}
\examples{
#simulate trait data for a series of individuals. to illustrate the point, simulate
#varying numbers of individuals per
#species, and where there are varying degrees of variance in traits per species. 
traits <- data.frame(trait1=c(rnorm(n=30, sd=1), rnorm(n=60, sd=2), rnorm(n=120,sd=4)),
trait2=c(rnorm(n=30, sd=1), rnorm(n=60, sd=2), rnorm(n=120, sd=4)))

#ordinate those trait data
ord <- prcomp(traits)

#pull out the positions of the points in the ordination space, and specify which
#species those individuals belong to
ex <- data.frame(ord$x)
ex$species <- c(rep("species1", 30), rep("species2",30), rep("species3",150))

test <- makeRoadMap(ex)
}
\references{
Miller, E. T. 2016. Random thoughts, though please cite metricTester via
our 2016 Ecography paper.
}

