% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepFieldData.R
\name{prepFieldData}
\alias{prepFieldData}
\title{Prep data to to calculate phylogenetic fields}
\usage{
prepFieldData(tree, dists, picante.cdm)
}
\arguments{
\item{tree}{Phylo object.}

\item{dists}{A symmetric distance matrix can be directly supplied. By doing
this, the user is implying that trait fields should be calculated.}

\item{picante.cdm}{A picante-style community data matrix with sites as rows, and
species as columns}
}
\value{
An object of class field.input
}
\description{
Given a phylo object, and a picante-style community data matrix (sites are rows,
species are columns), prepare data for calculation of phylogenetic or trait fields.
}
\details{
Returns a named list with four elements: the original phylogenetic tree
phylogenetic distances among species, the original picante-style CDM, and an argument,
specifying whether the phylogenetic or trait field should be calculated. This is
determined by the inputs. If a tree is supplied, the phylogenetic fields will be
calculated. If a distance matrix is supplied, the trait fields will be calculated.
Importantly, note that some metrics require a tree for calculation. These metrics
include PSV, PSC, PD, and QE. If a trait distance matrix is supplied, and these metrics
are called, the distances will be automatically coerced into a dendrogram via the
hclust function and conversion to an ape phylogeny.
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)

prepped <- prepFieldData(tree=tree, picante.cdm=cdm)
}
\references{
Miller, Wagner, Harmon & Ricklefs. In review. Radiating despite a lack of
character: closely related, morphologically similar, co-occurring honeyeaters have
diverged ecologically.
}

