% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaErrorWrapper.R
\name{betaErrorWrapper}
\alias{betaErrorWrapper}
\title{Read in and calculate type I and II error rates of a set of beta metric tests}
\usage{
betaErrorWrapper(working.directory)
}
\arguments{
\item{working.directory}{Optional character string specifying the working directory.
If missing, the current working directory will be used.}
}
\value{
A data frame of spatial simulations, null models, and metric combinations,
summarizing the results of all the betaMultiLinker runs in the working directory.
Numbers refer to total number of runs that resulted in an error. Errors for the random
spatial simulation refer to type I errors, errors for habitat filtering simulation
refer to type II errors for detecting filtering, and errors for competitive
exclusion refer to type II errors for detecting competition.
}
\description{
Reads in the results of a set of betaMultiLinker results and summarizes the type I and
II error rates of the various metric-null combinations under different assembly
processes.
}
\details{
The internal Reduce call in this function is not formatted to my liking (ETM).
Ideally, it would return a list of the length of the number of spatial simulations,
then a data frame for each spatial simulation. Instead, consolidates all to a single
data frame. It would be easy to make it work with for loops, but it should also be
possible to revise the Reduce call and make it return results properly formatted.
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}
