% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NSE.R
\name{NSE}
\alias{NSE}
\title{Nash-Sutcliffe Model Efficiency (NSE)}
\usage{
NSE(data = NULL, obs, pred, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric}.
}
\description{
It estimates the model efficiency suggested by Nash & Sutcliffe (1970)
for a continuous predicted-observed dataset.
}
\details{
The NSE measures general agreement. It is normalized (by the variance of the observations) and dimensionless.
It is calculated using the absolute squared differences between the predictions and observations,
which has been suggested as an issue due to over-sensitivity to outliers.
It goes form -infinity to 1. The closer to 1 the better the prediction performance.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- rnorm(n = 100, mean = 0, sd = 9)
NSE(obs = X, pred = Y)
}
}
\references{
Nash & Sutcliffe (1970).
River flow forecasting through conceptual models part I - A discussion of principles.
\emph{J. Hydrol. 10(3), 292-290.} \doi{10.1016/0022-1694(70)90255-6}
}
