% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefvariation.R
\name{thselect.cv}
\alias{thselect.cv}
\title{Threshold selection via coefficient of variation}
\usage{
thselect.cv(
  xdat,
  thresh,
  method = c("mle", "wcv", "cv"),
  nsim = 999L,
  nthresh = 10L,
  level = 0.05,
  lazy = FALSE,
  plot = FALSE
)
}
\arguments{
\item{xdat}{[vector] vector of observations}

\item{thresh}{[vector] vector of threshold. If missing, set to \eqn{p^k} for \eqn{k=0} to \eqn{k=}\code{nthresh}}

\item{method}{[string], either moment estimator for the (weighted) coefficient of variation (\code{wcv} and \code{cv}) or maximum likelihood (\code{mle})}

\item{nsim}{[integer] number of bootstrap replications}

\item{nthresh}{[integer] number of thresholds, if \code{thresh} is not supplied by the user}

\item{level}{[numeric] probability level for sequential testing procedure}

\item{lazy}{[logical] compute the bootstrap p-value until the test stops rejecting at level \code{level}? Default to \code{FALSE}}

\item{plot}{[logical] if \code{TRUE}, returns a plot of the p-value path}
}
\value{
a list with elements
\itemize{
\item \code{thresh}: value of threshold returned by the procedure, \code{NA} if the hypothesis is rejected at all thresholds
\item \code{thresh0}: sorted vector of candidate thresholds
\item \code{cindex}: index of selected threshold among \code{thresh0} or \code{NA} if none returned
\item \code{pval}: bootstrap p-values, with \code{NA} if \code{lazy} and the p-value exceeds level at lower thresholds
\item \code{shape}: shape parameter estimates
\item \code{nexc}: number of exceedances of each threshold \code{thresh0}
\item \code{method}: estimation method for the shape parameter
}
}
\description{
This function computes the empirical coefficient of variation and
computes a weighted statistic comparing the squared distance with
the theoretical coefficient variation corresponding to a specific
shape parameter (estimated from the data using a moment estimator
as the value minimizing the test statistic, or using maximum likelihood).
The procedure stops if there are no more than 10 exceedances above the
highest threshold.
}
\note{
The authors suggest transformation of \deqn{Y = -1/(X + c) + 1/c,}
where \eqn{X} are exceedances and \eqn{c=\sigma/\xi} is the ratio of estimated scale and shape parameters. For heavy-tailed distributions with \eqn{\xi > 0.25}, this may be preferable, but must be conducted outside of the function.
}
\examples{
thselect.cv(
 xdat = rgp(1000),
 thresh = qgp(seq(0,0.9, by = 0.1)),
 nsim = 99,
 lazy = TRUE,
 plot = TRUE)

}
\references{
del Castillo, J. and M. Padilla (2016). \emph{Modelling extreme values by the residual coefficient of variation}, SORT, 40(\bold{2}), pp. 303--320.
}
